"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsAppSection = AlertDetailsAppSection;
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _metric_value_formatter = require("../../../../common/alerting/metrics/metric_value_formatter");
var _threshold = require("../../common/components/threshold");
var _metrics_source = require("../../../containers/metrics_source");
var _generate_unique_key = require("../lib/generate_unique_key");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/alert_details_app_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO Use a generic props for app sections https://github.com/elastic/kibana/issues/152690

function AlertDetailsAppSection({
  alert,
  rule
}) {
  const {
    charts
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const groups = alert.fields[_ruleDataUtils.ALERT_GROUP];
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END];
  const alertStart = alert.fields[_ruleDataUtils.ALERT_START];
  const alertStartAnnotation = {
    label: 'Alert',
    type: 'manual',
    key: {
      type: 'point_in_time',
      timestamp: alertStart
    },
    color: euiTheme.colors.danger,
    icon: 'alert',
    id: 'metric_threshold_alert_start_annotation'
  };
  const alertRangeAnnotation = {
    label: `${alertEnd ? 'Alert duration' : 'Active alert'}`,
    type: 'manual',
    key: {
      type: 'range',
      timestamp: alertStart,
      endTimestamp: alertEnd !== null && alertEnd !== void 0 ? alertEnd : (0, _moment.default)().toISOString()
    },
    color: (0, _eui.transparentize)(euiTheme.colors.danger, 0.2),
    id: `metric_threshold_${alertEnd ? 'recovered' : 'active'}_alert_range_annotation`
  };
  const annotations = [];
  annotations.push(alertStartAnnotation, alertRangeAnnotation);
  return !!rule.params.criteria ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "metricThresholdAppSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, rule.params.criteria.map((criterion, index) => {
    const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END], {
      size: criterion.timeSize,
      unit: criterion.timeUnit
    });
    let metricExpression = [{
      aggType: criterion.aggType,
      name: String.fromCharCode('A'.charCodeAt(0) + index),
      field: criterion.metric || ''
    }];
    if (criterion.customMetrics) {
      metricExpression = criterion.customMetrics.map(metric => ({
        name: metric.name,
        aggType: metric.aggType,
        field: metric.field || '',
        filter: metric.filter
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: (0, _generate_unique_key.generateUniqueKey)(criterion),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }, criterion.aggType.toUpperCase(), ' ', 'metric' in criterion ? criterion.metric : undefined)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minHeight: 150,
        minWidth: 160
      },
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
      chartProps: chartProps,
      id: `threshold-${(0, _generate_unique_key.generateUniqueKey)(criterion)}`,
      thresholds: criterion.threshold,
      value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES][index],
      valueFormatter: d => (0, _metric_value_formatter.metricValueFormatter)(d, 'metric' in criterion ? criterion.metric : undefined),
      title: _i18n.i18n.translate('xpack.infra.metrics.alertDetailsAppSection.thresholdTitle', {
        defaultMessage: 'Threshold breached'
      }),
      comparator: (0, _common.convertToBuiltInComparators)(criterion.comparator),
      warning: criterion.warningThreshold && criterion.warningComparator && {
        thresholds: criterion.warningThreshold,
        comparator: (0, _common.convertToBuiltInComparators)(criterion.warningComparator)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 5,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 17
      }
    }, metricsView && /*#__PURE__*/_react.default.createElement(_public.RuleConditionChart, {
      additionalFilters: (0, _public.getGroupFilters)(groups),
      metricExpression: {
        metrics: metricExpression,
        threshold: criterion.threshold,
        comparator: criterion.comparator,
        timeSize: criterion.timeSize,
        timeUnit: criterion.timeUnit,
        warningComparator: criterion.warningComparator,
        warningThreshold: criterion.warningThreshold
      },
      chartOptions: {
        // For alert details page, the series type needs to be changed to 'bar_stacked'
        // due to https://github.com/elastic/elastic-charts/issues/2323
        seriesType: 'bar_stacked'
      },
      searchConfiguration: {
        query: {
          query: '',
          language: ''
        }
      },
      timeRange: timeRange,
      dataView: metricsView.dataViewReference,
      groupBy: rule.params.groupBy,
      annotations: annotations,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 21
      }
    })))));
  })) : null;
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = (0, _metrics_source.withSourceProvider)(AlertDetailsAppSection)('default');