"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLANNING_TOOLS = void 0;
exports.isPlanningToolName = isPlanningToolName;
exports.removeReasonToolCalls = removeReasonToolCalls;
exports.removeSystemToolCalls = removeSystemToolCalls;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLANNING_TOOLS = exports.PLANNING_TOOLS = {
  reason: {
    description: 'reason or reflect about the task ahead or the results',
    schema: {
      type: 'object',
      properties: {}
    }
  },
  complete: {
    description: 'complete the task based on the last output',
    schema: {
      type: 'object',
      properties: {}
    }
  }
};
function isPlanningToolName(name) {
  return Object.keys(PLANNING_TOOLS).includes(name);
}
function removeReasonToolCalls(messages) {
  return messages.filter(message => {
    var _message$toolCalls;
    const isInternalMessage = message.role === _inferenceCommon.MessageRole.Tool && message.name === 'reason' || message.role === _inferenceCommon.MessageRole.Assistant && ((_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.some(toolCall => toolCall.function.name === 'reason'));
    return !isInternalMessage;
  });
}
function removeSystemToolCalls(messages) {
  return messages.filter(message => {
    var _message$toolCalls2;
    const isInternalMessage = message.role === _inferenceCommon.MessageRole.Tool && isPlanningToolName(message.name) || message.role === _inferenceCommon.MessageRole.Assistant && ((_message$toolCalls2 = message.toolCalls) === null || _message$toolCalls2 === void 0 ? void 0 : _message$toolCalls2.some(toolCall => isPlanningToolName(toolCall.function.name)));
    return !isInternalMessage;
  });
}