"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/runtime_fields/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmptyPrompt = ({
  createField,
  runtimeFieldsDocsUri
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    "data-test-subj": "emptyList",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptTitle', {
      defaultMessage: 'Start by creating a runtime field'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptDescription",
      defaultMessage: "Define a field in the mapping and evaluate it at search time.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("br", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: runtimeFieldsDocsUri,
      target: "_blank",
      "data-test-subj": "learnMoreLink",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptDocumentionLink', {
      defaultMessage: 'Learn more.'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => createField(),
      iconType: "plusInCircle",
      "data-test-subj": "createRuntimeFieldButton",
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptButtonLabel', {
      defaultMessage: 'Create runtime field'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
};
exports.EmptyPrompt = EmptyPrompt;