"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Detail = Detail;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _has_deferred_installations = require("../../../../../../services/has_deferred_installations");
var _services = require("../../../../../../../common/services");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _setup_technology = require("../../../../../fleet/sections/agent_policy/create_package_policy_page/single_page_layout/hooks/setup_technology");
var _constants2 = require("../../../../constants");
var _services2 = require("../../../../services");
var _types = require("../../../../types");
var _components = require("../../../../components");
var _layouts = require("../../../../layouts");
var _side_bar_column = require("../../components/side_bar_column");
var _deferred_assets_warning = require("./assets/deferred_assets_warning");
var _hooks2 = require("./hooks");
var _utils = require("./utils");
var _components2 = require("./components");
var _assets = require("./assets");
var _overview = require("./overview");
var _policies = require("./policies");
var _settings = require("./settings");
var _custom = require("./custom");
var _documentation = require("./documentation");
var _configs = require("./configs");
var _install_button = require("./settings/install_button");
var _edit_integration_flyout = require("./components/edit_integration_flyout");
var _icon_panel = require("./components/icon_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CUSTOM_INTEGRATION_SOURCES = ['custom', 'upload'];
const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${props => props.theme.eui.euiBorderThin};
`;

// Allows child text to be truncated
const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
`;

// to limit size of iconpanel, making the header too big
const FlexItemWithMaxHeight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media (min-width: 768px) {
    max-height: 60px;
  }
`;
function Breadcrumbs({
  packageTitle
}) {
  (0, _hooks.useBreadcrumbs)('integration_details_overview', {
    pkgTitle: packageTitle
  });
  return null;
}
function Detail() {
  var _services$cloud, _packageInfo$name, _packageInfo$installa, _packageInfoData$item, _packageInfoData$item2, _packageInfo$categori;
  const theme = (0, _eui.useEuiTheme)();
  const {
    getId: getAgentPolicyId
  } = (0, _hooks.useAgentPolicyContext)();
  const {
    getFromIntegrations
  } = (0, _hooks.useIntegrationsStateContext)();
  const {
    pkgkey,
    panel
  } = (0, _reactRouterDom.useParams)();
  const {
    getHref,
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    pathname,
    search,
    hash
  } = (0, _reactRouterDom.useLocation)();
  const {
    isAgentlessIntegration,
    isAgentlessDefault
  } = (0, _setup_technology.useAgentless)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const integration = (0, _react.useMemo)(() => queryParams.get('integration'), [queryParams]);
  const prerelease = (0, _react.useMemo)(() => Boolean(queryParams.get('prerelease')), [queryParams]);
  /** Users from Security and Observability Solution onboarding pages will have returnAppId and returnPath
   ** in the query params to redirect back to the onboarding page after adding an integration
   */
  const returnAppId = (0, _react.useMemo)(() => queryParams.get('returnAppId'), [queryParams]);
  const returnPath = (0, _react.useMemo)(() => queryParams.get('returnPath'), [queryParams]);
  const authz = (0, _hooks.useAuthz)();
  const canAddAgent = authz.fleet.addAgents;
  const canInstallPackages = authz.integrations.installPackages;
  const canReadPackageSettings = authz.integrations.readPackageSettings;
  const canReadIntegrationPolicies = authz.integrations.readIntegrationPolicies;
  const {
    data: permissionCheck,
    error: permissionCheckError,
    isLoading: isPermissionCheckLoading
  } = (0, _hooks.usePermissionCheckQuery)();
  const missingSecurityConfiguration = !(permissionCheck !== null && permissionCheck !== void 0 && permissionCheck.success) && permissionCheckError === 'MISSING_SECURITY';
  const userCanInstallPackages = canInstallPackages && (permissionCheck === null || permissionCheck === void 0 ? void 0 : permissionCheck.success);
  const services = (0, _hooks.useStartServices)();
  const isCloud = !!(services !== null && services !== void 0 && (_services$cloud = services.cloud) !== null && _services$cloud !== void 0 && _services$cloud.cloudId);
  const agentPolicyIdFromContext = getAgentPolicyId();
  // edit readme state

  const [isEditOpen, setIsEditOpen] = (0, _react.useState)(false);
  const [isCustomPackage, setIsCustomPackage] = (0, _react.useState)(false);

  // Package info state
  const [packageInfo, setPackageInfo] = (0, _react.useState)(null);
  const setPackageInstallStatus = (0, _hooks.useSetPackageInstallStatus)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const CustomAssets = (0, _hooks.useUIExtension)((_packageInfo$name = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '', 'package-detail-assets');
  const packageInstallStatus = (0, _react.useMemo)(() => {
    var _getPackageInstallSta;
    if (packageInfo === null || !packageInfo.name) {
      return undefined;
    }
    return (_getPackageInstallSta = getPackageInstallStatus(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name)) === null || _getPackageInstallSta === void 0 ? void 0 : _getPackageInstallSta.status;
  }, [packageInfo, getPackageInstallStatus]);
  const isInstalled = (0, _react.useMemo)(() => packageInstallStatus === _types.InstallStatus.installed || packageInstallStatus === _types.InstallStatus.reinstalling, [packageInstallStatus]);
  const updateAvailable = packageInfo && 'installationInfo' in packageInfo && ((_packageInfo$installa = packageInfo.installationInfo) === null || _packageInfo$installa === void 0 ? void 0 : _packageInfo$installa.version) && (0, _lt.default)(packageInfo.installationInfo.version, packageInfo.latestVersion);
  const [prereleaseIntegrationsEnabled, setPrereleaseIntegrationsEnabled] = _react.default.useState();
  const {
    data: settings,
    isInitialLoading: isSettingsInitialLoading
  } = (0, _hooks.useGetSettingsQuery)({
    enabled: authz.fleet.readSettings
  });
  (0, _react.useEffect)(() => {
    const isEnabled = Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled) || prerelease;
    setPrereleaseIntegrationsEnabled(isEnabled);
  }, [settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled, prerelease]);
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(pkgkey);
  // Fetch package info
  const {
    data: packageInfoData,
    error: packageInfoError,
    isLoading: packageInfoLoading,
    isFetchedAfterMount: packageInfoIsFetchedAfterMount,
    refetch: refetchPackageInfo
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, pkgVersion, {
    prerelease: prereleaseIntegrationsEnabled,
    withMetadata: true
  }, {
    enabled: !authz.fleet.readSettings || !isSettingsInitialLoading,
    // Load only after settings are loaded
    refetchOnMount: 'always'
  });
  const [latestGAVersion, setLatestGAVersion] = (0, _react.useState)();
  const [latestPrereleaseVersion, setLatestPrereleaseVersion] = (0, _react.useState)();

  // fetch latest GA version (prerelease=false)
  const {
    data: packageInfoLatestGAData
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, '', {
    prerelease: false
  });
  (0, _react.useEffect)(() => {
    const pkg = packageInfoLatestGAData === null || packageInfoLatestGAData === void 0 ? void 0 : packageInfoLatestGAData.item;
    const isGAVersion = pkg && !(0, _services.isPackagePrerelease)(pkg.version);
    if (isGAVersion) {
      setLatestGAVersion(pkg.version);
    }
  }, [packageInfoLatestGAData === null || packageInfoLatestGAData === void 0 ? void 0 : packageInfoLatestGAData.item]);

  // fetch latest Prerelease version (prerelease=true)
  const {
    data: packageInfoLatestPrereleaseData
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, '', {
    prerelease: true
  });
  (0, _react.useEffect)(() => {
    setLatestPrereleaseVersion(packageInfoLatestPrereleaseData === null || packageInfoLatestPrereleaseData === void 0 ? void 0 : packageInfoLatestPrereleaseData.item.version);
  }, [packageInfoLatestPrereleaseData === null || packageInfoLatestPrereleaseData === void 0 ? void 0 : packageInfoLatestPrereleaseData.item.version]);
  const {
    isFirstTimeAgentUser = false,
    isLoading: firstTimeUserLoading
  } = (0, _hooks2.useIsFirstTimeAgentUserQuery)();

  // Refresh package info when status change
  const [oldPackageInstallStatus, setOldPackageStatus] = (0, _react.useState)(packageInstallStatus);
  (0, _react.useEffect)(() => {
    if (packageInstallStatus === 'not_installed') {
      setOldPackageStatus(packageInstallStatus);
    }
    if (oldPackageInstallStatus === 'not_installed' && packageInstallStatus === 'installed') {
      setOldPackageStatus(packageInstallStatus);
      refetchPackageInfo();
    }
  }, [packageInstallStatus, oldPackageInstallStatus, refetchPackageInfo]);
  const isLoading = packageInfoLoading || isPermissionCheckLoading || firstTimeUserLoading || !packageInfoIsFetchedAfterMount;
  const showCustomTab = (0, _hooks.useUIExtension)((_packageInfoData$item = packageInfoData === null || packageInfoData === void 0 ? void 0 : (_packageInfoData$item2 = packageInfoData.item) === null || _packageInfoData$item2 === void 0 ? void 0 : _packageInfoData$item2.name) !== null && _packageInfoData$item !== void 0 ? _packageInfoData$item : '', 'package-detail-custom') !== undefined;

  // Only show config tab if package has `inputs`
  const showConfigTab = canAddAgent && (packageInfo ? (0, _services.packageToPackagePolicyInputs)(packageInfo).length > 0 : false);

  // Only show API references tab if it is allowed & has documentation to show
  const showDocumentationTab = !_constants.HIDDEN_API_REFERENCE_PACKAGES.includes(pkgName) && packageInfo && (0, _documentation.hasDocumentation)({
    packageInfo,
    integration
  });

  // Track install status state
  (0, _react.useEffect)(() => {
    if (packageInfoIsFetchedAfterMount && packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item) {
      var _ref, _packageInfoResponse$, _packageInfoResponse$2;
      const packageInfoResponse = packageInfoData.item;
      setPackageInfo(packageInfoResponse);
      setIsCustomPackage((_ref = (packageInfoResponse === null || packageInfoResponse === void 0 ? void 0 : (_packageInfoResponse$ = packageInfoResponse.installationInfo) === null || _packageInfoResponse$ === void 0 ? void 0 : _packageInfoResponse$.install_source) && CUSTOM_INTEGRATION_SOURCES.includes((_packageInfoResponse$2 = packageInfoResponse.installationInfo) === null || _packageInfoResponse$2 === void 0 ? void 0 : _packageInfoResponse$2.install_source)) !== null && _ref !== void 0 ? _ref : false);
      let installedVersion;
      const {
        name
      } = packageInfoData.item;
      if ('installationInfo' in packageInfoResponse) {
        var _packageInfoResponse$3;
        installedVersion = (_packageInfoResponse$3 = packageInfoResponse.installationInfo) === null || _packageInfoResponse$3 === void 0 ? void 0 : _packageInfoResponse$3.version;
      }
      const status = packageInfoResponse === null || packageInfoResponse === void 0 ? void 0 : packageInfoResponse.status;
      if (name) {
        setPackageInstallStatus({
          name,
          status,
          version: installedVersion || null
        });
      }
    }
  }, [packageInfoData, packageInfoIsFetchedAfterMount, setPackageInstallStatus, setPackageInfo]);
  const integrationInfo = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    return integration ? packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.find(policyTemplate => policyTemplate.name === integration) : undefined;
  }, [integration, packageInfo]);
  const fromIntegrations = getFromIntegrations();
  const fromIntegrationsPath = fromIntegrations === 'updates_available' ? getPath('integrations_installed_updates_available') : fromIntegrations === 'installed' ? getPath('integrations_installed') : getPath('integrations_all');
  const numOfDeferredInstallations = (0, _react.useMemo)(() => (0, _has_deferred_installations.getDeferredInstallationsCnt)(packageInfo), [packageInfo]);
  const headerLeftContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "headerLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.BackLink, {
    queryParams: queryParams,
    integrationsPath: fromIntegrationsPath,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithMaxHeight, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 13
    }
  }, packageInfoError ? /*#__PURE__*/_react.default.createElement(_icon_panel.ErrorIconPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 17
    }
  }) : isLoading || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components2.LoadingIconPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_components2.IconPanel, {
    packageName: packageInfo.name,
    integrationName: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
    version: packageInfo.version,
    icons: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons) || packageInfo.icons,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  }, packageInfo ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "flexStart",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 23
    }
  }, (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) || '\u00A0'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 21
    }
  }, (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.type) === 'content' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 27
    }
  }, _i18n.i18n.translate('xpack.fleet.epm.contentPackageBadgeLabel', {
    defaultMessage: 'Content only'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 27
    }
  }, _i18n.i18n.translate('xpack.fleet.epm.elasticAgentBadgeLabel', {
    defaultMessage: 'Elastic Agent'
  }))), packageInfo !== null && packageInfo !== void 0 && packageInfo.release && packageInfo.release !== 'ga' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_components.HeaderReleaseBadge, {
    release: (0, _services.getPackageReleaseLabel)(packageInfo.version),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 27
    }
  })) : null))) : null)))), [integrationInfo, isLoading, packageInfo, fromIntegrationsPath, queryParams, packageInfoError]);
  const handleEditIntegrationClick = (0, _react.useCallback)(ev => {
    setIsEditOpen(true);
  }, []);
  const handleAddIntegrationPolicyClick = (0, _react.useCallback)(ev => {
    var _defaultNavigateOptio, _defaultNavigateOptio2;
    ev.preventDefault();
    // The object below, given to `createHref` is explicitly accessing keys of `location` in order
    // to ensure that dependencies to this `useCallback` is set correctly (because `location` is mutable)
    const currentPath = history.createHref({
      pathname,
      search,
      hash
    });
    const defaultNavigateOptions = (0, _utils.getInstallPkgRouteOptions)({
      agentPolicyId: agentPolicyIdFromContext,
      currentPath,
      integration,
      isCloud,
      isFirstTimeAgentUser,
      pkgkey,
      prerelease,
      isAgentlessIntegration: isAgentlessIntegration(packageInfo || undefined),
      isAgentlessDefault
    });

    /** Users from Security and Observability Solution onboarding pages will have returnAppId and returnPath
     ** in the query params to redirect back to the onboarding page after adding an integration
     */
    const navigateOptions = returnAppId && returnPath ? [defaultNavigateOptions[0], {
      ...defaultNavigateOptions[1],
      state: {
        ...((_defaultNavigateOptio = (_defaultNavigateOptio2 = defaultNavigateOptions[1]) === null || _defaultNavigateOptio2 === void 0 ? void 0 : _defaultNavigateOptio2.state) !== null && _defaultNavigateOptio !== void 0 ? _defaultNavigateOptio : {}),
        onCancelNavigateTo: [returnAppId, {
          path: returnPath
        }],
        onCancelUrl: services.application.getUrlForApp(returnAppId, {
          path: returnPath
        }),
        onSaveNavigateTo: [returnAppId, {
          path: returnPath
        }]
      }
    }] : defaultNavigateOptions;
    services.application.navigateToApp(...navigateOptions);
  }, [history, pathname, search, hash, agentPolicyIdFromContext, integration, isCloud, isFirstTimeAgentUser, pkgkey, prerelease, isAgentlessIntegration, packageInfo, isAgentlessDefault, returnAppId, returnPath, services.application]);
  const showVersionSelect = (0, _react.useMemo)(() => prereleaseIntegrationsEnabled && latestGAVersion && latestPrereleaseVersion && latestGAVersion !== latestPrereleaseVersion && (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.version) || packageInfo.version === latestGAVersion || packageInfo.version === latestPrereleaseVersion), [prereleaseIntegrationsEnabled, latestGAVersion, latestPrereleaseVersion, packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version]);
  const versionOptions = (0, _react.useMemo)(() => [{
    value: latestPrereleaseVersion,
    text: latestPrereleaseVersion
  }, {
    value: latestGAVersion,
    text: latestGAVersion
  }], [latestPrereleaseVersion, latestGAVersion]);
  const versionLabel = _i18n.i18n.translate('xpack.fleet.epm.versionLabel', {
    defaultMessage: 'Version'
  });
  const onVersionChange = (0, _react.useCallback)((version, packageName) => {
    const path = getPath('integration_details_overview', {
      pkgkey: `${packageName}-${version}`
    });
    history.push(path);
  }, [getPath, history]);
  const headerRightContent = (0, _react.useMemo)(() => packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 520,
      columnNumber: 11
    }
  }, [{
    label: showVersionSelect ? undefined : versionLabel,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 526,
        columnNumber: 21
      }
    }, showVersionSelect ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "versionSelect",
      prepend: versionLabel,
      options: versionOptions,
      value: packageInfo.version,
      "aria-label": versionLabel,
      onChange: event => onVersionChange(event.target.value, packageInfo.name),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 528,
        columnNumber: 25
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "versionText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 539,
        columnNumber: 25
      }
    }, packageInfo.version)), updateAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 543,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.UpdateIcon, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 25
      }
    })) : null)
  }, ...(isInstalled && packageInfo.type !== 'content' ? [{
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.epm.policiesCountLabel', {
      defaultMessage: 'Policies'
    }),
    'data-test-subj': 'policyCount',
    content: /*#__PURE__*/_react.default.createElement(_components2.IntegrationPolicyCount, {
      packageName: packageInfo.name,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 32
      }
    })
  }] : []), ...(packageInfo.type === 'content' ? !isInstalled ? [{
    isDivider: true
  }, {
    content: /*#__PURE__*/_react.default.createElement(_install_button.InstallButton, (0, _extends2.default)({}, packageInfo, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 564,
        columnNumber: 54
      }
    }))
  }] : [] // if content package is already installed, don't show install button in header
  : [{
    isDivider: true
  }, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 570,
        columnNumber: 25
      }
    }, isCustomPackage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 572,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.EditIntegrationButton, {
      handleEditIntegrationClick: handleEditIntegrationClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 573,
        columnNumber: 31
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 578,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_components2.AddIntegrationButton, {
      userCanInstallPackages: userCanInstallPackages,
      href: getHref('add_integration_to_policy', {
        pkgkey,
        ...(integration ? {
          integration
        } : {}),
        ...(agentPolicyIdFromContext ? {
          agentPolicyId: agentPolicyIdFromContext
        } : {})
      }),
      missingSecurityConfiguration: missingSecurityConfiguration,
      packageName: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
      onClick: handleAddIntegrationPolicyClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 579,
        columnNumber: 29
      }
    })))
  }])].map((item, index) => {
    var _item$isDivider;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index,
      "data-test-subj": item['data-test-subj'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 15
      }
    }, ((_item$isDivider = item.isDivider) !== null && _item$isDivider !== void 0 ? _item$isDivider : false) ? /*#__PURE__*/_react.default.createElement(Divider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 600,
        columnNumber: 19
      }
    }) : item.label ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      className: "eui-textRight",
      compressed: true,
      textStyle: "reverse",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 602,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 603,
        columnNumber: 21
      }
    }, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 604,
        columnNumber: 21
      }
    }, item.content)) : item.content);
  }))) : undefined, [packageInfo, updateAvailable, isInstalled, pkgkey, userCanInstallPackages, getHref, integration, agentPolicyIdFromContext, missingSecurityConfiguration, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title, handleAddIntegrationPolicyClick, onVersionChange, showVersionSelect, versionLabel, versionOptions, handleEditIntegrationClick, isCustomPackage]);
  const headerTabs = (0, _react.useMemo)(() => {
    if (!packageInfo) {
      return [];
    }
    const packageInfoKey = (0, _services2.pkgKeyFromPackageInfo)(packageInfo);
    const pathValues = {
      pkgkey: packageInfoKey,
      ...(integration ? {
        integration
      } : {}),
      ...(returnAppId ? {
        returnAppId
      } : {}),
      ...(returnPath ? {
        returnPath
      } : {})
    };
    const tabs = [{
      id: 'overview',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetailsNav.overviewLinkText",
        defaultMessage: "Overview",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 651,
          columnNumber: 11
        }
      }),
      isSelected: panel === 'overview',
      'data-test-subj': `tab-overview`,
      href: getHref('integration_details_overview', pathValues)
    }];
    if (canReadIntegrationPolicies && isInstalled && packageInfo.type !== 'content') {
      tabs.push({
        id: 'policies',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packagePoliciesLinkText",
          defaultMessage: "Integration policies",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 666,
            columnNumber: 11
          }
        }),
        isSelected: panel === 'policies',
        'data-test-subj': `tab-policies`,
        href: getHref('integration_details_policies', pathValues)
      });
    }
    if (isInstalled && (packageInfo.assets || CustomAssets)) {
      tabs.push({
        id: 'assets',
        name: /*#__PURE__*/_react.default.createElement("div", {
          style: {
            display: 'flex',
            textAlign: 'center'
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 681,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packageAssetsLinkText",
          defaultMessage: "Assets",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 682,
            columnNumber: 13
          }
        }), "\xA0", numOfDeferredInstallations > 0 ? /*#__PURE__*/_react.default.createElement(_deferred_assets_warning.DeferredAssetsWarning, {
          numOfDeferredInstallations: numOfDeferredInstallations,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 688,
            columnNumber: 15
          }
        }) : null),
        isSelected: panel === 'assets',
        'data-test-subj': `tab-assets`,
        href: getHref('integration_details_assets', pathValues)
      });
    }
    if (canReadPackageSettings) {
      tabs.push({
        id: 'settings',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.settingsLinkText",
          defaultMessage: "Settings",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 702,
            columnNumber: 11
          }
        }),
        isSelected: panel === 'settings',
        'data-test-subj': `tab-settings`,
        href: getHref('integration_details_settings', pathValues)
      });
    }
    if (canReadPackageSettings && showConfigTab) {
      tabs.push({
        id: 'configs',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.configsText",
          defaultMessage: "Configs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 717,
            columnNumber: 11
          }
        }),
        isSelected: panel === 'configs',
        'data-test-subj': `tab-configs`,
        href: getHref('integration_details_configs', pathValues)
      });
    }
    if (canReadPackageSettings && showCustomTab) {
      tabs.push({
        id: 'custom',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packageCustomLinkText",
          defaultMessage: "Advanced",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 732,
            columnNumber: 11
          }
        }),
        isSelected: panel === 'custom',
        'data-test-subj': `tab-custom`,
        href: getHref('integration_details_custom', pathValues)
      });
    }
    if (showDocumentationTab) {
      tabs.push({
        id: 'api-reference',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.documentationLinkText",
          defaultMessage: "API reference",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 747,
            columnNumber: 11
          }
        }),
        isSelected: panel === 'api-reference',
        'data-test-subj': `tab-api-reference`,
        href: getHref('integration_details_api_reference', pathValues)
      });
    }
    return tabs;
  }, [packageInfo, returnAppId, returnPath, panel, getHref, integration, canReadIntegrationPolicies, isInstalled, CustomAssets, canReadPackageSettings, showConfigTab, showCustomTab, showDocumentationTab, numOfDeferredInstallations]);
  const securityCallout = missingSecurityConfiguration ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutTitle",
      defaultMessage: "Security needs to be enabled in order to add Elastic Agent integrations",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 782,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 778,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutDescription",
    defaultMessage: "In order to fully use Fleet, you must enable Elasticsearch and Kibana security features. Follow the {guideLink} to enable security.",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement("a", {
        href: services.http.basePath.prepend('/app/fleet'),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 794,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutDescriptionGuideLink",
        defaultMessage: "steps in this guide",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 795,
          columnNumber: 17
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 788,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 804,
      columnNumber: 7
    }
  })) : undefined;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    rightColumnGrow: false,
    topContent: securityCallout,
    tabs: headerTabs,
    tabsCss: `
        margin-left: calc(${theme.euiTheme.size.base} * 6 + ${theme.euiTheme.size.xl} * 2 +
          ${theme.euiTheme.size.l});
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 809,
      columnNumber: 5
    }
  }, integrationInfo || packageInfo ? /*#__PURE__*/_react.default.createElement(Breadcrumbs, {
    packageTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) || '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 821,
      columnNumber: 9
    }
  }) : null, packageInfoError ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 824,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 825,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 826,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.loadingIntegrationErrorTitle",
      defaultMessage: "Error loading integration details",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 829,
        columnNumber: 17
      }
    }),
    error: packageInfoError.message,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 827,
      columnNumber: 13
    }
  }))) : isLoading || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 839,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 841,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_overview,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 842,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview.OverviewPage, {
    packageInfo: packageInfo,
    integrationInfo: integrationInfo,
    latestGAVersion: latestGAVersion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 843,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_settings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 849,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_settings.SettingsPage, {
    packageInfo: packageInfo,
    packageMetadata: packageInfoData === null || packageInfoData === void 0 ? void 0 : packageInfoData.metadata,
    startServices: services,
    isCustomPackage: isCustomPackage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 850,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_assets,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 857,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_assets.AssetsPage, {
    packageInfo: packageInfo,
    refetchPackageInfo: refetchPackageInfo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 858,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_configs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 860,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_configs.Configs, {
    packageInfo: packageInfo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 861,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_policies,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 863,
      columnNumber: 11
    }
  }, canReadIntegrationPolicies ? /*#__PURE__*/_react.default.createElement(_policies.PackagePoliciesPage, {
    packageInfo: packageInfo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 865,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_layouts.PermissionsError, {
    error: "MISSING_PRIVILEGES",
    requiredFleetRole: "Agent Policies Read and Integrations Read",
    callingApplication: "Integrations",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 867,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_custom,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 874,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_custom.CustomViewPage, {
    packageInfo: packageInfo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 875,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_api_reference,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 877,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_documentation.DocumentationPage, {
    packageInfo: packageInfo,
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 878,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_overview,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 880,
      columnNumber: 11
    }
  })), isEditOpen && /*#__PURE__*/_react.default.createElement(_edit_integration_flyout.EditIntegrationFlyout, {
    integrationName: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) || 'Integration',
    onClose: () => setIsEditOpen(false),
    packageInfo: packageInfo,
    setIsEditOpen: setIsEditOpen,
    integration: integration,
    services: services,
    existingCategories: (_packageInfo$categori = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.categories) !== null && _packageInfo$categori !== void 0 ? _packageInfo$categori : [],
    onComplete: urlParts => {
      const path = getPath('integration_details_overview', urlParts);
      history.push(path);
    },
    miniIcon: isLoading || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 898,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_components2.MiniIcon, {
      packageName: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name,
      integrationName: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
      version: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version,
      icons: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.icons),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 900,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 884,
      columnNumber: 9
    }
  }));
}