"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSLFormSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _multi_row_input = require("../multi_row_input");
var _output_form_secret_form_row = require("../edit_output_flyout/output_form_secret_form_row");
var _types = require("../../../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_server_hosts_flyout/ssl_form_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SSLFormSection = props => {
  const {
    inputs,
    useSecretsStorage,
    isConvertedToSecret,
    onToggleSecretAndClearValue
  } = props;
  const clientAuthenticationsOptions = [{
    id: _types.clientAuth.None,
    label: 'None',
    'data-test-subj': 'clientAuthNoneRadioButton'
  }, {
    id: _types.clientAuth.Required,
    label: 'Required',
    'data-test-subj': 'clientAuthUsernamePasswordRadioButton'
  }, {
    id: _types.clientAuth.Optional,
    label: 'Optional',
    'data-test-subj': 'clientAuthSSLRadioButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedSSLOptions",
    "data-test-subj": "advancedSSLOptionsButton",
    buttonClassName: "ingest-active-button",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerHosts.SSLOptionsToggleLabel",
      defaultMessage: "Authentication",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerHosts.SSLOptionsToggleLabel",
      defaultMessage: "Set up a TLS secure connection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify the CA certificate(s) that signed the Elastic Agent client certificates connecting to this Fleet Server. Fleet Server trusts these CAs when verifying incoming connections.'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Fleet Server > Elastic Agents certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslCertificateInputLabel",
      defaultMessage: "Fleet Server > SSL server certificate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    })
  }, inputs.sslCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslCertificateInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL certificate used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslKeyInputLabel",
      defaultMessage: "Fleet Server > SSL server private key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 17
      }
    })
  }, inputs.sslKeyInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    disabled: !useSecretsStorage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL key used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeySecretInputTitle', {
      defaultMessage: 'Fleet Server > SSL server private key'
    })
  }, inputs.sslKeySecretInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    cancelEdit: inputs.sslKeySecretInput.cancelEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeySecretInput.props, {
    "data-test-subj": "sslKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeySecretInputPlaceholder', {
      defaultMessage: 'Specify the Fleet Server SSL key used to secure communication with incoming Elastic Agent connections.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify the Elasticsearch CA certificate(s) that Fleet Server should trust when connecting to Elasticsearch.'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Fleet Server > Elasticsearch certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslEsCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslEsCertificateInputLabel",
      defaultMessage: "Fleet Server > SSL client certificate for Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 15
      }
    })
  }, inputs.sslEsCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslEsCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsCertificateInputPlaceholder', {
      defaultMessage: 'Specify the SSL client certificate that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.sslEsKeyInputLabel",
      defaultMessage: "Fleet Server > SSL private key for Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 17
      }
    })
  }, inputs.sslESKeyInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    disabled: !useSecretsStorage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslESKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslEsKeySecretInputTitle', {
      defaultMessage: 'Fleet Server > SSL private key for Elasticsearch'
    })
  }, inputs.sslESKeySecretInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret.sslKey,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    cancelEdit: inputs.sslESKeySecretInput.cancelEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslESKeySecretInput.props, {
    "data-test-subj": "sslESKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHosts.sslESKeySecretInputPlaceholder', {
      defaultMessage: 'Specify the SSL key that the Fleet Server should use when connecting to Elasticsearch. Only needed for mTLS between Fleet Server and Elasticsearch.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHosts.clientAuthenticationInputLabel",
      defaultMessage: "Client auth",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    style: {
      flexDirection: 'row',
      flexWrap: 'wrap',
      columnGap: 30
    },
    "data-test-subj": 'fleetServerHosts.clientAuthenticationRadioInput',
    options: clientAuthenticationsOptions,
    compressed: true,
    name: "clientAuth"
  }, inputs.sslClientAuthInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }))))));
};
exports.SSLFormSection = SSLFormSection;