"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryClient = exports.DebugPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Evaluate moving this react-query initialization up to the main Fleet app
// setup if we end up pursuing wider adoption of react-query.
const queryClient = exports.queryClient = new _reactQuery.QueryClient();
const panels = [{
  title: _i18n.i18n.translate('xpack.fleet.debug.HealthCheckStatus.title', {
    defaultMessage: 'Health Check Status'
  }),
  id: 'healthCheckStatus',
  component: /*#__PURE__*/_react.default.createElement(_components.HealthCheckPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.agentPolicyDebugger.title', {
    defaultMessage: 'Agent Policy Debugger'
  }),
  id: 'agentPolicyDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.title', {
    defaultMessage: 'Integration Debugger'
  }),
  id: 'integrationDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.IntegrationDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.title', {
    defaultMessage: 'Saved Object Debugger'
  }),
  id: 'savedObjectDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.SavedObjectDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.fleetIndexDebugger.title', {
    defaultMessage: 'Fleet Index Debugger'
  }),
  id: 'fleetIndexDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.FleetIndexDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.title', {
    defaultMessage: 'Preconfiguration Debugger'
  }),
  id: 'preconfigurationDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.PreconfigurationDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title', {
    defaultMessage: 'Orphaned Integration Policy Debugger'
  }),
  id: 'orphanedIntegrationPolicyDebugger',
  component: /*#__PURE__*/_react.default.createElement(_components.OrphanedIntegrationPolicyDebugger, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 16
    }
  })
}];
const DebugPage = ({
  isInitialized,
  setupError
}) => {
  const {
    chrome
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  chrome.docTitle.change(['Debug', 'Fleet']);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: _i18n.i18n.translate('xpack.fleet.debug.pageTitle', {
      defaultMessage: 'Fleet Debugging Dashboard'
    }),
    iconType: "wrench",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: "Danger zone",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.dangerZone.description",
    defaultMessage: "This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",
    values: {
      strongDestructive: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.debug.dangerZone.destructive",
        defaultMessage: "destructive",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 25
        }
      })),
      strongLossOfData: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.debug.dangerZone.lossOfData",
        defaultMessage: "loss of data",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 25
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }))), !isInitialized && (setupError === null || setupError === void 0 ? void 0 : setupError.message) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: "Setup error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.initializationError.description",
    defaultMessage: "{message}. You can use this page to debug the error.",
    values: {
      message: setupError === null || setupError === void 0 ? void 0 : setupError.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, panels.map(({
    title,
    id,
    component
  }) => /*#__PURE__*/_react.default.createElement("div", {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 23
      }
    }, title)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }), component), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.usefulLinks.title",
    defaultMessage: "Useful links",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: [{
      label: _i18n.i18n.translate('xpack.fleet.debug.usefulLinks.viewAgents', {
        defaultMessage: 'View Agents in Fleet UI'
      }),
      href: getHref('agent_list'),
      iconType: 'agentApp',
      target: '_blank'
    }, {
      label: _i18n.i18n.translate('xpack.fleet.debug.usefulLinks.troubleshootingGuide', {
        defaultMessage: 'Troubleshooting Guide'
      }),
      href: 'https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html',
      iconType: 'popout',
      target: '_blank'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }));
};
exports.DebugPage = DebugPage;