"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/filter_bar/agent_policy_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyFilter = ({
  selectedAgentPolicies,
  onSelectedAgentPoliciesChange,
  agentPolicies
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  // Policies state for filtering
  const [isAgentPoliciesFilterOpen, setIsAgentPoliciesFilterOpen] = (0, _react.useState)(false);

  // Add a agent policy id to current search
  const addAgentPolicyFilter = policyId => {
    onSelectedAgentPoliciesChange([...selectedAgentPolicies, policyId]);
  };

  // Remove a agent policy id from current search
  const removeAgentPolicyFilter = policyId => {
    onSelectedAgentPoliciesChange(selectedAgentPolicies.filter(agentPolicy => agentPolicy !== policyId));
  };
  const getOptions = (0, _react.useCallback)(() => {
    return agentPolicies.map(agentPolicy => ({
      label: agentPolicy.name,
      checked: selectedAgentPolicies.includes(agentPolicy.id) ? 'on' : undefined,
      key: agentPolicy.id,
      'data-test-subj': 'agentList.agentPolicyFilterOption'
    }));
  }, [agentPolicies, selectedAgentPolicies]);
  const [options, setOptions] = (0, _react.useState)(getOptions());
  (0, _react.useEffect)(() => {
    setOptions(getOptions());
  }, [getOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    zIndex: Number(euiTheme.levels.header) - 1,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsAgentPoliciesFilterOpen(!isAgentPoliciesFilterOpen),
      isSelected: isAgentPoliciesFilterOpen,
      hasActiveFilters: selectedAgentPolicies.length > 0,
      numActiveFilters: selectedAgentPolicies.length,
      numFilters: agentPolicies.length,
      disabled: agentPolicies.length === 0,
      "data-test-subj": "agentList.policyFilter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.policyFilterText",
      defaultMessage: "Agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    })),
    isOpen: isAgentPoliciesFilterOpen,
    closePopover: () => setIsAgentPoliciesFilterOpen(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: newOptions => {
      setOptions(newOptions);
      newOptions.forEach((option, index) => {
        if (option.checked !== options[index].checked) {
          const agentPolicyId = option.key;
          if (option.checked !== 'on') {
            removeAgentPolicyFilter(agentPolicyId);
          } else {
            addAgentPolicyFilter(agentPolicyId);
          }
          return;
        }
      });
    },
    "data-test-subj": "agentList.agentPolicyFilterOptions",
    listProps: {
      paddingSize: 's',
      style: {
        minWidth: 200
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, list => list));
};
exports.AgentPolicyFilter = AgentPolicyFilter;