"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateServiceTokenStep = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _generate_service_token = require("../../generate_service_token");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/create_service_token.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ContentWrapper = exports.ContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
  margin: 0 auto;
  max-width: 800px;
`;
const getGenerateServiceTokenStep = ({
  disabled = false,
  serviceToken,
  generateServiceToken,
  isLoadingServiceToken
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepGenerateServiceTokenTitle', {
      defaultMessage: 'Generate a service token'
    }),
    status: disabled ? 'disabled' : undefined,
    children: !disabled && /*#__PURE__*/_react.default.createElement(_generate_service_token.GenerateServiceTokenComponent, {
      serviceToken: serviceToken,
      generateServiceToken: generateServiceToken,
      isLoadingServiceToken: isLoadingServiceToken,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    })
  };
};
exports.getGenerateServiceTokenStep = getGenerateServiceTokenStep;