"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormWizardProvider = exports.FormWizardConsumer = void 0;
exports.useFormWizardContext = useFormWizardContext;
var _react = _interopRequireWildcard(require("react"));
var _multi_content = require("../multi_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/public/forms/form_wizard/form_wizard_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formWizardContext = /*#__PURE__*/(0, _react.createContext)({});
const FormWizardProvider = exports.FormWizardProvider = (0, _multi_content.WithMultiContent)(function FormWizardProvider({
  children,
  defaultActiveStep = 0,
  isEditing,
  onSave,
  onStepChange
}) {
  var _state$steps$state$ac;
  const {
    getData,
    validate,
    validation
  } = (0, _multi_content.useMultiContentContext)();
  const [state, setState] = (0, _react.useState)({
    activeStepIndex: defaultActiveStep,
    steps: {}
  });
  const activeStepId = (_state$steps$state$ac = state.steps[state.activeStepIndex]) === null || _state$steps$state$ac === void 0 ? void 0 : _state$steps$state$ac.id;
  const lastStep = Object.keys(state.steps).length - 1;
  const isCurrentStepValid = validation.contents[activeStepId];
  const addStep = (0, _react.useCallback)((id, label, isRequired = false) => {
    setState(prev => {
      const index = Object.keys(prev.steps).length;
      return {
        ...prev,
        steps: {
          ...prev.steps,
          [index]: {
            id,
            index,
            label,
            isRequired,
            isComplete: isEditing !== null && isEditing !== void 0 ? isEditing : false
          }
        }
      };
    });
  }, [isEditing]);

  /**
   * Get the step index from a step id.
   */
  const getStepIndex = (0, _react.useCallback)(stepId => {
    if (typeof stepId === 'number') {
      return stepId;
    }

    // We provided a string stepId, we need to find the corresponding index
    const targetStep = Object.values(state.steps).find(_step => _step.id === stepId);
    if (!targetStep) {
      throw new Error(`Can't navigate to step "${stepId}" as there are no step with that ID.`);
    }
    return targetStep.index;
  }, [state.steps]);
  const navigateToStep = (0, _react.useCallback)(async stepId => {
    // Before navigating away we validate the active content in the DOM
    const isValid = await validate();

    // If step is not valid do not go any further
    if (!isValid) {
      return;
    }
    const nextStepIndex = getStepIndex(stepId);
    if (nextStepIndex > lastStep) {
      // We are on the last step, save the data and don't go any further
      onSave(getData());
      return;
    }

    // Update the active step
    setState(prev => {
      const currentStep = prev.steps[prev.activeStepIndex];
      const nextState = {
        ...prev,
        activeStepIndex: nextStepIndex
      };
      if (nextStepIndex > prev.activeStepIndex && !currentStep.isComplete) {
        // Mark the current step as completed
        nextState.steps[prev.activeStepIndex] = {
          ...currentStep,
          isComplete: true
        };
      }
      return nextState;
    });
    // Trigger onStepChange
    if (onStepChange) {
      var _Object$values$getSte;
      onStepChange((_Object$values$getSte = Object.values(state.steps)[getStepIndex(stepId)]) === null || _Object$values$getSte === void 0 ? void 0 : _Object$values$getSte.id);
    }
  }, [getStepIndex, validate, onSave, onStepChange, getData, lastStep, state.steps]);
  const value = {
    ...state,
    activeStepId,
    lastStep,
    isCurrentStepValid,
    addStep,
    navigateToStep
  };
  return /*#__PURE__*/_react.default.createElement(formWizardContext.Provider, {
    value: value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 10
    }
  }, children);
});
const FormWizardConsumer = exports.FormWizardConsumer = formWizardContext.Consumer;
function useFormWizardContext() {
  const ctx = (0, _react.useContext)(formWizardContext);
  if (ctx === undefined) {
    throw new Error('useFormWizardContext() must be called within a <FormWizardProvider />');
  }
  return ctx;
}