"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upgradeBuiltInEntityDefinitions = upgradeBuiltInEntityDefinitions;
var _install_entity_definition = require("./install_entity_definition");
var _start_transforms = require("./start_transforms");
var _auth = require("../auth");
var _utils = require("../utils");
var _errors = require("../../../common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO(kuba): File contains a single, unused function upgradeBuiltInEntityDefinitions()

async function upgradeBuiltInEntityDefinitions({
  definitions,
  server
}) {
  const {
    logger
  } = server;
  const apiKey = await (0, _auth.readEntityDiscoveryAPIKey)(server);
  if (!apiKey) {
    return {
      success: false,
      reason: _errors.ERROR_API_KEY_NOT_FOUND
    };
  }
  const isValid = await (0, _auth.checkIfEntityDiscoveryAPIKeyIsValid)(server, apiKey);
  if (!isValid) {
    throw new Error('Stored API key is not valid, skipping built-in definition upgrade. You can re-enable Entity Discovery to update the key.');
  }
  const {
    clusterClient,
    soClient
  } = (0, _utils.getClientsFromAPIKey)({
    apiKey,
    server
  });
  const esClient = clusterClient.asCurrentUser;
  logger.debug(`Starting built-in definitions upgrade`);
  const upgradedDefinitions = await (0, _install_entity_definition.installBuiltInEntityDefinitions)({
    esClient,
    soClient,
    isServerless: false,
    definitions,
    logger
  });
  await Promise.all(upgradedDefinitions.map(definition => (0, _start_transforms.startTransforms)(esClient, definition, logger)));
  return {
    success: true,
    definitions: upgradedDefinitions
  };
}