"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncRulesStateCallouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/connector/sync_rules/sync_rules_callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SyncRulesStateCallouts = ({
  applyDraft,
  editDraft,
  state
}) => {
  switch (state) {
    case _searchConnectors.FilteringValidationState.EDITED:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 33,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 35,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingTitle', {
          defaultMessage: 'Draft sync rules are validating'
        }))),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingDescription', {
        defaultMessage: 'Draft rules need to be validated before they can be activated. This may take a few minutes.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-validatingCallout-editRules",
        onClick: editDraft,
        color: "warning",
        fill: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingCallout.editDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))));
    case _searchConnectors.FilteringValidationState.INVALID:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        iconType: "cross",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.invalidTitle', {
          defaultMessage: 'Draft sync rules are invalid'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.invalidDescription', {
        defaultMessage: 'Draft rules did not validate. Edit the draft rules before they can be activated.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-errorCallout-editRules",
        onClick: editDraft,
        color: "danger",
        fill: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.errorCallout.editDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))));
    case _searchConnectors.FilteringValidationState.VALID:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "success",
        iconType: "check",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatedTitle', {
          defaultMessage: 'Draft sync rules validated'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatedDescription', {
        defaultMessage: 'Activate draft rules to take effect on the next sync.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-successCallout-applyRules",
        onClick: applyDraft,
        color: "success",
        fill: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.successCallout.applyDraftRulesTitle', {
        defaultMessage: 'Activate draft rules'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-successCallout-editRules",
        onClick: editDraft,
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.errorCallout.successEditDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))))));
    default:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.SyncRulesStateCallouts = SyncRulesStateCallouts;