"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnsConfiguration = exports.DataTableSummaryColumnHeaderLogsContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/logs_data_source_profile/accessors/get_columns_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getColumnsConfiguration = prev => () => ({
  ...(prev ? prev() : {}),
  _source: ({
    column,
    headerRowHeight
  }) => ({
    ...column,
    display: /*#__PURE__*/_react.default.createElement(DataTableSummaryColumnHeaderLogsContext, {
      columnDisplayName: column.displayAsText,
      headerRowHeight: headerRowHeight,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    })
  })
});
exports.getColumnsConfiguration = getColumnsConfiguration;
const DataTableSummaryColumnHeaderLogsContext = ({
  headerRowHeight = 1,
  columnDisplayName
}) => {
  const tooltipTitle = _i18n.i18n.translate('discover.unifiedDataTable.tableHeader.logsContext.sourceFieldIconTooltipTitle', {
    defaultMessage: 'Summary including the following fields'
  });
  const tooltipContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.unifiedDataTable.tableHeader.logsContext.sourceFieldIconTooltip",
    defaultMessage: "Displays the most relevant resource identifiers like:{br}{br}- service.name{br}- host.name{br}- kubernetes.pod.name{br}- etc.{br}{br}followed by the log or error message.{br}If no message fields are present, it shows the full document instead.",
    values: {
      br: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTableSummaryColumnHeader, {
    columnDisplayName: columnDisplayName,
    headerRowHeight: headerRowHeight,
    tooltipTitle: tooltipTitle,
    tooltipContent: tooltipContent,
    iconTipDataTestSubj: "logs-summary-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
};
exports.DataTableSummaryColumnHeaderLogsContext = DataTableSummaryColumnHeaderLogsContext;