"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEsQuery = fetchEsQuery;
var _extract_key = require("./extract_key");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_GROUPS = 1000;
async function fetchEsQuery({
  index,
  groupBy,
  query = {},
  services,
  dateStart
}) {
  var _esResult$aggregation, _esResult$aggregation2;
  const {
    scopedClusterClient
  } = services;
  const esClient = scopedClusterClient.asCurrentUser;
  const {
    must
  } = query;
  const bool = {
    filter: [{
      range: {
        '@timestamp': {
          gte: new Date(dateStart).getTime()
        }
      }
    }]
  };
  const aggs = {
    ...(groupBy.length > 0 ? {
      dataStreams: {
        ...(groupBy.length === 1 ? {
          terms: {
            field: groupBy[0],
            size: DEFAULT_GROUPS,
            order: {
              _count: 'desc'
            }
          }
        } : {
          multi_terms: {
            terms: groupBy.map(field => ({
              field,
              missing: _types.MISSING_VALUE
            })),
            size: DEFAULT_GROUPS,
            order: {
              _count: 'desc'
            }
          }
        })
      }
    } : {})
  };
  const esResult = await esClient.search({
    index,
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        ...bool,
        ...(must ? {
          must
        } : {})
      }
    },
    aggs
  });
  const dataStreamBuckets = ((_esResult$aggregation = esResult.aggregations) === null || _esResult$aggregation === void 0 ? void 0 : (_esResult$aggregation2 = _esResult$aggregation.dataStreams) === null || _esResult$aggregation2 === void 0 ? void 0 : _esResult$aggregation2.buckets) || [];

  // Group values by dataStream name instead of backing index name
  const groupedDataStreams = dataStreamBuckets.reduce((acc, bucket) => {
    var _acc$key$join$docCoun, _acc$key$join;
    const key = (0, _extract_key.extractKey)({
      groupBy,
      bucketKey: Array.isArray(bucket.key) ? bucket.key : [bucket.key]
    });
    return {
      ...acc,
      [key.join(',')]: {
        bucketKey: key,
        docCount: ((_acc$key$join$docCoun = (_acc$key$join = acc[key.join(',')]) === null || _acc$key$join === void 0 ? void 0 : _acc$key$join.docCount) !== null && _acc$key$join$docCoun !== void 0 ? _acc$key$join$docCoun : 0) + bucket.doc_count
      }
    };
  }, {});
  return Object.keys(groupedDataStreams).reduce((obj, bucket) => {
    obj[groupedDataStreams[bucket].bucketKey.join(',')] = {
      docCount: groupedDataStreams[bucket].docCount,
      bucketKey: groupedDataStreams[bucket].bucketKey
    };
    return obj;
  }, {});
}