"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileClashResult = exports.FileClashIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_clash.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FileClashResult = ({
  fileClash
}) => {
  if (fileClash.clash === _fileUpload.CLASH_ERROR_TYPE.ERROR) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      title: getClashText(fileClash),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  if (fileClash.clash === _fileUpload.CLASH_ERROR_TYPE.WARNING) {
    var _fileClash$newFields, _fileClash$missingFie, _fileClash$newFields2, _fileClash$missingFie2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      title: getClashText(fileClash),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    }, (_fileClash$newFields = fileClash.newFields) !== null && _fileClash$newFields !== void 0 && _fileClash$newFields.length || (_fileClash$missingFie = fileClash.missingFields) !== null && _fileClash$missingFie !== void 0 && _fileClash$missingFie.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }) : null, (_fileClash$newFields2 = fileClash.newFields) !== null && _fileClash$newFields2 !== void 0 && _fileClash$newFields2.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileStatus.newFields",
      defaultMessage: "File contains {count} new fields which are not present in the selected index.",
      values: {
        count: fileClash.newFields.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 15
      }
    }))) : null, (_fileClash$missingFie2 = fileClash.missingFields) !== null && _fileClash$missingFie2 !== void 0 && _fileClash$missingFie2.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileStatus.missingFields",
      defaultMessage: "File is missing {count} fields which are present in the selected index",
      values: {
        count: fileClash.missingFields.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }))) : null);
  }
};
exports.FileClashResult = FileClashResult;
function getClashText(fileClash) {
  if (fileClash.clash === _fileUpload.CLASH_ERROR_TYPE.ERROR) {
    if (fileClash.clashType === _fileUpload.CLASH_TYPE.FORMAT) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.fileFormatClash",
        defaultMessage: "File format different from other files",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 9
        }
      });
    }
    if (fileClash.clashType === _fileUpload.CLASH_TYPE.MAPPING) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.mappingClash",
        defaultMessage: "Mappings incompatible with other files",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      });
    }
    if (fileClash.clashType === _fileUpload.CLASH_TYPE.EXISTING_INDEX_MAPPING) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.existingIndexMappingClash",
        defaultMessage: "Mappings incompatible with existing index",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 9
        }
      });
    }
    if (fileClash.clashType === _fileUpload.CLASH_TYPE.UNSUPPORTED) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.fileFormatNotSupported",
        defaultMessage: "File format not supported",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 9
        }
      });
    }
  }
  if (fileClash.clash === _fileUpload.CLASH_ERROR_TYPE.WARNING) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileStatus.fileClashWarning",
      defaultMessage: "Mappings may be incompatible with the existing index",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    });
  }
}
const FileClashIcon = ({
  fileClash
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  switch (fileClash.clash) {
    case _fileUpload.CLASH_ERROR_TYPE.ERROR:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: getClashText(fileClash),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: euiTheme.colors.backgroundBaseDanger,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "alert",
        color: "danger",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 13
        }
      })));
    case _fileUpload.CLASH_ERROR_TYPE.WARNING:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: getClashText(fileClash),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: euiTheme.colors.backgroundBaseWarning,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        color: "warning",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 13
        }
      })));
    default:
      return null;
  }
};
exports.FileClashIcon = FileClashIcon;