"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRangeLegend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _d = _interopRequireDefault(require("d3"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/hooks/color_range_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COLOR_RANGE_RESOLUTION = 10;
/**
 * Component to render a legend for color ranges to be used for color coding
 * table cells and visualizations.
 *
 * This current version supports normalized value ranges (0-1) only.
 *
 * @param props ColorRangeLegendProps
 */
const ColorRangeLegend = ({
  colorRange,
  justifyTicks = false,
  showTicks = true,
  title,
  width = 250
}) => {
  const d3Container = (0, _react.useRef)(null);
  const scale = _d.default.range(COLOR_RANGE_RESOLUTION + 1).map(d => ({
    offset: d / COLOR_RANGE_RESOLUTION * 100,
    stopColor: colorRange(d / COLOR_RANGE_RESOLUTION)
  }));
  (0, _react.useEffect)(() => {
    if (d3Container.current === null) {
      return;
    }
    const wrapperHeight = 32;
    const wrapperWidth = width;

    // top: 2        — adjust vertical alignment with title text
    // bottom: 20    — room for axis ticks and labels
    // left/right: 1 — room for first and last axis tick
    // when justifyTicks is enabled, the left margin is increased to not cut off the first tick label
    const margin = {
      top: 2,
      bottom: 20,
      left: justifyTicks || !showTicks ? 1 : 4,
      right: 1
    };
    const legendWidth = wrapperWidth - margin.left - margin.right;
    const legendHeight = wrapperHeight - margin.top - margin.bottom;

    // remove, then redraw the legend
    _d.default.select(d3Container.current).selectAll('*').remove();
    const wrapper = _d.default.select(d3Container.current).classed('colorRangeLegend', true).attr('width', wrapperWidth).attr('height', wrapperHeight).append('g').attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');

    // append gradient bar
    const gradient = wrapper.append('defs').append('linearGradient').attr('id', 'colorRangeGradient').attr('x1', '0%').attr('y1', '0%').attr('x2', '100%').attr('y2', '0%').attr('spreadMethod', 'pad');
    scale.forEach(function (d) {
      gradient.append('stop').attr('offset', `${d.offset}%`).attr('stop-color', d.stopColor).attr('stop-opacity', 1);
    });
    wrapper.append('rect').attr('x1', 0).attr('y1', 0).attr('width', legendWidth).attr('height', legendHeight).style('fill', 'url(#colorRangeGradient)');
    const axisScale = _d.default.scale.linear().domain([0, 1]).range([0, legendWidth]);

    // Using this formatter ensures we get e.g. `0` and not `0.0`, but still `0.1`, `0.2` etc.
    const tickFormat = _d.default.format('');
    const legendAxis = _d.default.svg.axis().scale(axisScale).orient('bottom').tickFormat(tickFormat).tickSize(legendHeight + 4).ticks(legendWidth / 40);
    wrapper.append('g').attr('class', 'legend axis').attr('transform', 'translate(0, 0)').call(legendAxis);

    // Adjust the alignment of the first and last tick text
    // so that the tick labels don't overflow the color range.
    if (justifyTicks || !showTicks) {
      const text = wrapper.selectAll('text')[0];
      if (text.length > 1) {
        _d.default.select(text[0]).style('text-anchor', 'start');
        _d.default.select(text[text.length - 1]).style('text-anchor', 'end');
      }
    }
    if (!showTicks) {
      wrapper.selectAll('.axis line').style('display', 'none');
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(scale), d3Container.current]);
  if (title === undefined) {
    return /*#__PURE__*/_react.default.createElement("svg", {
      ref: d3Container,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement("svg", {
    ref: d3Container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }));
};
exports.ColorRangeLegend = ColorRangeLegend;