"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLayoutState = exports.LayoutStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _layout_config_context = require("./layout_config_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/layout_state_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LayoutStateContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * The layout state provider component.
 * Wires up the LayoutConfig to the layout state.
 *
 * @param props - Props for the LayoutStateProvider component.
 * @returns The rendered LayoutStateProvider component.
 */
const LayoutStateProvider = ({
  children,
  ...props
}) => {
  var _layoutConfig$bannerH, _layoutConfig$footerH, _layoutConfig$headerH, _layoutConfig$navigat, _layoutConfig$sidebar, _layoutConfig$applica, _layoutConfig$applica2;
  // Get layout config from context
  const layoutConfig = (0, _layout_config_context.useLayoutConfig)();
  const slots = {
    Header: props.header || null,
    Navigation: props.navigation || null,
    Banner: props.banner || null,
    Footer: props.footer || null,
    Sidebar: props.sidebar || null,
    ApplicationTopBar: props.applicationTopBar || null,
    ApplicationBottomBar: props.applicationBottomBar || null
  };
  const hasBanner = !!slots.Banner;
  const hasFooter = !!slots.Footer;
  const hasSidebar = !!slots.Sidebar;
  const hasHeader = !!slots.Header;
  const hasNavigation = !!slots.Navigation;
  const hasApplicationTopBar = !!slots.ApplicationTopBar;
  const hasApplicationBottomBar = !!slots.ApplicationBottomBar;
  const layoutState = {
    hasBanner,
    bannerHeight: hasBanner ? (_layoutConfig$bannerH = layoutConfig.bannerHeight) !== null && _layoutConfig$bannerH !== void 0 ? _layoutConfig$bannerH : 0 : 0,
    hasFooter,
    footerHeight: hasFooter ? (_layoutConfig$footerH = layoutConfig.footerHeight) !== null && _layoutConfig$footerH !== void 0 ? _layoutConfig$footerH : 0 : 0,
    hasHeader,
    headerHeight: hasHeader ? (_layoutConfig$headerH = layoutConfig.headerHeight) !== null && _layoutConfig$headerH !== void 0 ? _layoutConfig$headerH : 0 : 0,
    hasNavigation,
    navigationWidth: hasNavigation ? (_layoutConfig$navigat = layoutConfig.navigationWidth) !== null && _layoutConfig$navigat !== void 0 ? _layoutConfig$navigat : 0 : 0,
    hasSidebar,
    sidebarWidth: hasSidebar ? (_layoutConfig$sidebar = layoutConfig.sidebarWidth) !== null && _layoutConfig$sidebar !== void 0 ? _layoutConfig$sidebar : 0 : 0,
    hasApplicationTopBar,
    applicationTopBarHeight: hasApplicationTopBar ? (_layoutConfig$applica = layoutConfig.applicationTopBarHeight) !== null && _layoutConfig$applica !== void 0 ? _layoutConfig$applica : 0 : 0,
    hasApplicationBottomBar,
    applicationBottomBarHeight: hasApplicationBottomBar ? (_layoutConfig$applica2 = layoutConfig.applicationBottomBarHeight) !== null && _layoutConfig$applica2 !== void 0 ? _layoutConfig$applica2 : 0 : 0
  };
  return /*#__PURE__*/_react.default.createElement(LayoutStateContext.Provider, {
    value: layoutState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 10
    }
  }, children);
};
exports.LayoutStateProvider = LayoutStateProvider;
const useLayoutState = () => {
  const context = (0, _react.useContext)(LayoutStateContext);
  if (context === undefined) {
    throw new Error('useLayoutState must be used within a LayoutStateProvider');
  }
  return context;
};
exports.useLayoutState = useLayoutState;