"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoFindingsStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _empty_states_illustration_container = require("../empty_states_illustration_container");
var _full_size_centered_page = require("../full_size_centered_page");
var _use_navigate_to_cis_integration_policies = require("../../common/navigation/use_navigate_to_cis_integration_policies");
var _test_subjects = require("../test_subjects");
var _cloud_posture_page = require("../cloud_posture_page");
var _clouds = _interopRequireDefault(require("../../assets/illustrations/clouds.svg"));
var _misconfiguration_vendor_bright = _interopRequireDefault(require("../../assets/illustrations/misconfiguration_vendor_bright.svg"));
var _misconfiguration_vendor_dark = _interopRequireDefault(require("../../assets/illustrations/misconfiguration_vendor_dark.svg"));
var _use_csp_integration_link = require("../../common/navigation/use_csp_integration_link");
var _constants = require("../../common/constants");
var _constants2 = require("../../common/navigation/constants");
var _use_add_integrations_route = require("../../common/api/use_add_integrations_route");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/no_findings_states/no_findings_states.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NotDeployed = ({
  postureType
}) => {
  const integrationPoliciesLink = (0, _use_navigate_to_cis_integration_policies.useCISIntegrationPoliciesLink)({
    postureType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.NO_AGENTS_DEPLOYED,
    color: "plain",
    iconType: "fleetApp",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedTitle",
      defaultMessage: "No Agents Installed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedDescription",
      defaultMessage: "In order to begin detecting security misconfigurations, you'll need to deploy elastic-agent into the cloud account or Kubernetes cluster you want to monitor.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: integrationPoliciesLink,
      isDisabled: !integrationPoliciesLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noFindingsStates.noAgentsDeployed.noAgentsDeployedButtonTitle",
      defaultMessage: "Install Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
const Indexing = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.INDEXING,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexing.indexingButtonTitle",
    defaultMessage: "Posture evaluation underway",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexing.indexingDescription",
    defaultMessage: "Waiting for data to be collected and indexed. Check back later to see your findings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 3
  }
});
const IndexTimeout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.INDEX_TIMEOUT,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutTitle",
    defaultMessage: "Waiting for Findings data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutDescription",
    defaultMessage: "Collecting findings is taking longer than expected. {docs}.",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/findings",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.noFindingsStates.indexTimeout.indexTimeoutDocLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 3
  }
});
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.UNPRIVILEGED,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noFindingsStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view cloud posture data, you must update privileges. For more information, contact your Kibana administrator.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.csp.noFindingsStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 147,
    columnNumber: 3
  }
});
const EmptySecurityFindingsPrompt = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const kspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE);
  const cspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE);
  const is3PSupportedPage = location.pathname.includes(_cloudSecurityPosture.findingsNavigation.findings_default.path);
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const addIntegrationRouteLink = (0, _use_add_integrations_route.useAddIntegrationRoute)('misconfiguration_workflow');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _cloud_posture_page.PACKAGE_NOT_INSTALLED_TEST_SUBJECT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _clouds.default,
      alt: "clouds",
      role: "presentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.promptTitle",
      defaultMessage: "Elastic\u2019s Cloud Security {lineBreak} Posture Management",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 209,
            columnNumber: 30
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.promptDescription",
      defaultMessage: "Detect and remediate potential configuration {lineBreak} risks in your cloud infrastructure, with our {lineBreak} Cloud and Kubernetes Security Posture {lineBreak} Management solutions. {learnMore}",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 30
          }
        }),
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.learnMoreTitle",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 225,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 15
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: cspmIntegrationLink,
      isDisabled: !cspmIntegrationLink,
      "data-test-subj": _test_subjects.CSPM_NOT_INSTALLED_ACTION_SUBJ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.addCspmIntegrationButtonTitle",
      defaultMessage: "Add CSPM Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: kspmIntegrationLink,
      isDisabled: !kspmIntegrationLink,
      "data-test-subj": _test_subjects.KSPM_NOT_INSTALLED_ACTION_SUBJ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.packageNotInstalledRenderer.addKspmIntegrationButtonTitle",
      defaultMessage: "Add KSPM Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 19
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  })), is3PSupportedPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.THIRD_PARTY_INTEGRATIONS_NO_MISCONFIGURATIONS_FINDINGS_PROMPT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _misconfiguration_vendor_dark.default : _misconfiguration_vendor_bright.default,
      alt: isDarkMode ? 'misconfigurationsVendorDarkSVG' : 'misconfigurationsVendorBrightSVG',
      role: "presentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 17
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.promptTitle",
      defaultMessage: "Already using a {lineBreak} cloud security solution?",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 40
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 17
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.promptDescription",
      defaultMessage: "Ingest misconfiguration data to help you  {lineBreak}  analyze, hunt, and investigate threats by {lineBreak} providing contextual insights across your infrastructure.",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 306,
            columnNumber: 40
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 17
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: addIntegrationRouteLink,
      isDisabled: !addIntegrationRouteLink,
      "data-test-subj": _test_subjects.THIRD_PARTY_NO_MISCONFIGURATIONS_FINDINGS_PROMPT_INTEGRATION_BUTTON,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoFindingsPrompt.addIntegrationButtonTitle",
      defaultMessage: "Add Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 21
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  })));
};
const NoFindingsStatesNotification = ({
  postureType,
  status,
  indicesStatus,
  isNotInstalled
}) => {
  const unprivilegedIndices = indicesStatus && indicesStatus.filter(idxDetails => idxDetails.status === 'unprivileged').map(idxDetails => idxDetails.index).sort((a, b) => a.localeCompare(b));
  if (status === 'unprivileged') return /*#__PURE__*/_react.default.createElement(Unprivileged, {
    unprivilegedIndices: unprivilegedIndices || [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 12
    }
  });
  if (status === 'indexing' || status === 'waiting_for_results') return /*#__PURE__*/_react.default.createElement(Indexing, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 73
    }
  });
  if (status === 'index-timeout') return /*#__PURE__*/_react.default.createElement(IndexTimeout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 42
    }
  });
  if (isNotInstalled) return /*#__PURE__*/_react.default.createElement(EmptySecurityFindingsPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 30
    }
  });
  if (status === 'not-deployed') return /*#__PURE__*/_react.default.createElement(NotDeployed, {
    postureType: postureType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 41
    }
  });
  return null;
};

/**
 * This component will return the render states based on cloud posture setup status API
 * since 'not-installed' is being checked globally by CloudPosturePage and 'indexed' is the pass condition, those states won't be handled here
 * */
const NoFindingsStates = ({
  postureType
}) => {
  var _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2, _getSetupStatus$data3, _getSetupStatus$data4;
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: _constants.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS
  });
  const statusKspm = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.kspm) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const statusCspm = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : (_getSetupStatus$data3 = _getSetupStatus$data2.cspm) === null || _getSetupStatus$data3 === void 0 ? void 0 : _getSetupStatus$data3.status;
  const indicesStatus = (_getSetupStatus$data4 = getSetupStatus.data) === null || _getSetupStatus$data4 === void 0 ? void 0 : _getSetupStatus$data4.indicesDetails;
  const status = postureType === 'cspm' ? statusCspm : statusKspm;
  const isNotInstalled = statusKspm === 'not-installed' && statusCspm === 'not-installed';
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(NoFindingsStatesNotification, {
    postureType: postureType,
    status: status,
    indicesStatus: indicesStatus,
    isNotInstalled: isNotInstalled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 9
    }
  })));
};
exports.NoFindingsStates = NoFindingsStates;