"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/common/component/multi_select_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* This code is based on MultiSelectFilter component from x-pack/plugins/cases/public/components/all_cases/multi_select_filter.tsx */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fromRawOptionsToEuiSelectableOptions = (options, selectedOptionKeys) => {
  return options.map(({
    key,
    label
  }) => {
    const selectableOption = {
      label,
      key
    };
    if (selectedOptionKeys.includes(key)) {
      selectableOption.checked = 'on';
    }
    selectableOption['data-test-subj'] = `options-filter-popover-item-${key.split(' ').join('-')}`;
    return selectableOption;
  });
};
const fromEuiSelectableOptionToRawOption = options => {
  return options.map(option => option.key);
};
const getEuiSelectableCheckedOptions = options => options.filter(option => option.checked === 'on');
const MultiSelectFilter = ({
  buttonLabel,
  buttonIconType,
  hideActiveOptionsNumber,
  id,
  limit,
  limitReachedMessage,
  onChange,
  options: rawOptions,
  selectedOptionKeys = [],
  renderOption,
  transparentBackground
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const toggleIsPopoverOpen = () => setIsPopoverOpen(prevValue => !prevValue);
  const showActiveOptionsNumber = !hideActiveOptionsNumber;
  const isInvalid = Boolean(limit && limitReachedMessage && selectedOptionKeys.length >= limit);
  const options = fromRawOptionsToEuiSelectableOptions(rawOptions, selectedOptionKeys);
  (0, _react.useEffect)(() => {
    const newSelectedOptions = selectedOptionKeys.filter(selectedOptionKey => rawOptions.some(({
      key: optionKey
    }) => optionKey === selectedOptionKey));
    if (!(0, _fp.isEqual)(newSelectedOptions, selectedOptionKeys)) {
      onChange({
        filterId: id,
        selectedOptionKeys: newSelectedOptions
      });
    }
  }, [selectedOptionKeys, rawOptions, id, onChange]);
  const _onChange = newOptions => {
    const newSelectedOptions = getEuiSelectableCheckedOptions(newOptions);
    if (isInvalid && limit && newSelectedOptions.length >= limit) {
      return;
    }
    onChange({
      filterId: id,
      selectedOptionKeys: fromEuiSelectableOptionToRawOption(newSelectedOptions)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      css: (0, _react2.css)`
              max-width: 186px;
            `,
      "data-test-subj": `options-filter-popover-button-${id}`,
      iconType: buttonIconType || 'arrowDown',
      onClick: toggleIsPopoverOpen,
      isSelected: isPopoverOpen,
      numFilters: showActiveOptionsNumber ? options.length : undefined,
      hasActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length > 0 : undefined,
      numActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length : undefined,
      "aria-label": buttonLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, buttonLabel)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, isInvalid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: limitReachedMessage,
    color: "warning",
    size: "s",
    "data-test-subj": "maximum-length-warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.csp.common.component.multiSelectFilter.searchWord', {
        defaultMessage: 'Search '
      }) + buttonLabel,
      compressed: false,
      'data-test-subj': `${id}-search-input`,
      css: (0, _react2.css)`
              box-shadow: none;
            `
    },
    emptyMessage: 'empty',
    onChange: _onChange,
    singleSelection: false,
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                width: 400px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }, search), list))));
};
exports.MultiSelectFilter = MultiSelectFilter;
MultiSelectFilter.displayName = 'MultiSelectFilter';