"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutPrompt = TimeoutPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/timeout_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TimeoutPrompt({
  isGlobalServiceMap
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPromptTitle', {
      defaultMessage: 'Service map timeout'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPromptDescription', {
      defaultMessage: `Timed out while fetching data for service map. Limit the scope by selecting a smaller time range, or use configuration setting ''{configName}'' with a reduced value.`,
      values: {
        configName: isGlobalServiceMap ? 'xpack.apm.serviceMapFingerprintGlobalBucketSize' : 'xpack.apm.serviceMapFingerprintBucketSize'
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(ApmSettingsDocLink, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 16
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
}
function ApmSettingsDocLink() {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmApmSettingsDocLinkLearnMoreAboutApmSettingsInTheDocsLink",
    href: docLinks.links.apm.kibanaSettings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPrompt.docsLink', {
    defaultMessage: 'Learn more about APM settings in the docs'
  }));
}