"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vitest_1 = require("vitest");
// eslint-disable-next-line vitest/prefer-describe-function-title
(0, vitest_1.describe)('ServiceIdentifier', () => {
    (0, vitest_1.describe)('having an abstract class with public constructor', () => {
        class AbstractFoo {
        }
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            const identifier = AbstractFoo;
            (0, vitest_1.expect)(identifier).toBeInstanceOf(Function);
        });
    });
    (0, vitest_1.describe)('having an abstract class with protected constructor', () => {
        class AbstractFoo {
            constructor() { }
        }
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            const identifier = AbstractFoo;
            (0, vitest_1.expect)(identifier).toBeInstanceOf(Function);
        });
    });
    (0, vitest_1.describe)('having a class with public constructor', () => {
        class Foo {
        }
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            const identifier = Foo;
            (0, vitest_1.expect)(identifier).toBeInstanceOf(Function);
        });
    });
    (0, vitest_1.describe)('having a class with protected constructor', () => {
        class Foo {
            constructor() { }
        }
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            const identifier = Foo;
            (0, vitest_1.expect)(identifier).toBeInstanceOf(Function);
        });
    });
    (0, vitest_1.describe)('having a string', () => {
        let identifier;
        (0, vitest_1.beforeAll)(() => {
            identifier = 'Foo';
        });
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            (0, vitest_1.expect)(identifier).toBeTypeOf('string');
        });
    });
    (0, vitest_1.describe)('having a symbol', () => {
        let identifier;
        (0, vitest_1.beforeAll)(() => {
            identifier = Symbol('Foo');
        });
        (0, vitest_1.it)('should be a valid ServiceIdentifier', () => {
            (0, vitest_1.expect)(identifier).toBeTypeOf('symbol');
        });
    });
});
//# sourceMappingURL=ServiceIdentifier.spec-d.js.map