"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectSideNavV1 = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _navigation = require("./navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/sidenav_v1/sidenav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const PANEL_WIDTH = 290;
const ProjectSideNavV1 = ({
  isCollapsed$,
  toggle,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(CollapsibleNavigationFlyout, {
    isCollapsed$: isCollapsed$,
    toggle: toggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.Navigation, (0, _extends2.default)({}, rest, {
    isCollapsed$: isCollapsed$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  })));
};
exports.ProjectSideNavV1 = ProjectSideNavV1;
const CollapsibleNavigationFlyout = ({
  toggle,
  isCollapsed$,
  children
}) => {
  const isCollapsed = (0, _useObservable.default)(isCollapsed$, false);
  const className = (0, _classnames.default)('hide-for-sharing', (0, _css.css)`
      .euiFlyoutBody__overflowContent {
        height: 100%;
      }
    `);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavBeta, {
    "data-test-subj": "projectLayoutSideNav",
    isCollapsed: isCollapsed,
    onCollapseToggle: toggle,
    css: {
      overflow: 'visible',
      clipPath: `polygon(0 0, calc(var(--euiCollapsibleNavOffset) + ${PANEL_WIDTH}px) 0, calc(var(--euiCollapsibleNavOffset) + ${PANEL_WIDTH}px) 100%, 0 100%)`
    },
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, children);
};