"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalOnlyComponent = void 0;
var _shared_component = require("./shared_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class GlobalOnlyComponent extends _shared_component.SharedComponent {
  getTerms() {
    return null;
  }
  match(token, context) {
    const result = {
      next: []
    };

    // try to link to GLOBAL rules
    const globalRules = context.globalComponentResolver(token, false);
    if (globalRules) {
      result.next.push.apply(result.next, globalRules);
    }
    if (result.next.length) {
      return result;
    }
    // just loop back to us
    result.next = [this];
    return result;
  }
}
exports.GlobalOnlyComponent = GlobalOnlyComponent;