"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CnvmKspmSetup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/cloud-security-posture-common/constants");
var _cnvm_kspm_info = require("./cnvm_kspm_info");
var _kspm_eks_input_selector = require("./kspm_eks_input_selector");
var _eks_credentials_form = require("./eks_credentials_form");
var _constants2 = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/cnvm_kspm/cnvm_kspm_setup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isVulnMgmtAwsInput = input => {
  return input.type === _constants2.CLOUDBEAT_VULN_MGMT_AWS && input.policy_template === _constants2.VULN_MGMT_POLICY_TEMPLATE;
};
const isEksInput = input => {
  return input.type === _constants2.CLOUDBEAT_EKS && input.policy_template === _constants.KSPM_POLICY_TEMPLATE;
};
const isKspmInput = input => {
  return input.type === _constants2.CLOUDBEAT_VANILLA && input.policy_template === _constants.KSPM_POLICY_TEMPLATE;
};
const IntegrationSettings = ({
  onChange,
  fields
}) => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 3
  }
}, fields.map(({
  value,
  id,
  label,
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: id,
  id: id,
  fullWidth: true,
  label: label,
  isInvalid: !!error,
  error: error,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  isInvalid: !!error,
  fullWidth: true,
  value: value,
  onChange: event => onChange(id, event.target.value),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 9
  }
}))));
const CnvmKspmSetup = exports.CnvmKspmSetup = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  packageInfo,
  isEditPage,
  validationResults,
  input,
  setEnabledPolicyInput,
  updatePolicy
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const integrationFields = [{
    id: 'name',
    value: newPolicy.name,
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.name) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationNameLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    })
  }, {
    id: 'description',
    value: newPolicy.description || '',
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.description) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationDescriptionLabel",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    })
  }];
  if (isKspmInput(input) || isEksInput(input) || isVulnMgmtAwsInput(input)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cnvm_kspm_info.CnvmKspmTemplateInfo, {
      policyTemplate: input.policy_template,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }), (isEksInput(input) || isKspmInput(input)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kspm_eks_input_selector.KspmEksInputSelector, {
      input: input
      // @ts-expect-error - TypeScript doesn't know that input.policy_template is a key of DEFAULT_INPUT_TYPE
      ,
      setInput: setEnabledPolicyInput,
      disabled: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    })), isVulnMgmtAwsInput(input) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(IntegrationSettings, {
      fields: integrationFields,
      onChange: (field, value) => updatePolicy({
        updatedPolicy: {
          ...newPolicy,
          [field]: value
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }), !isVulnMgmtAwsInput(input) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "advancedOptions",
      "data-test-subj": "advancedOptionsAccordion",
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: euiTheme.colors.textPrimary,
        css: {
          fontWeight: euiTheme.font.weight.medium
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.fleetIntegration.advancedOptionsLabel",
        defaultMessage: "Advanced options",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 21
        }
      })),
      paddingSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_public.NamespaceComboBox, {
      fullWidth: true,
      namespace: newPolicy.namespace,
      placeholder: "default",
      isEditPage: isEditPage,
      validationError: validationResults === null || validationResults === void 0 ? void 0 : validationResults.namespace,
      onNamespaceChange: namespace => {
        updatePolicy({
          updatedPolicy: {
            ...newPolicy,
            namespace
          }
        });
      },
      "data-test-subj": "namespaceInput",
      labelId: "xpack.csp.fleetIntegration.namespaceLabel",
      helpTextId: "securitySolutionPackages.cloudSecurityPosture.cloudSetup.aws.accountType.awsOrganizationDescription",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 17
      }
    }))), isEksInput(input) && /*#__PURE__*/_react.default.createElement(_eks_credentials_form.EksCredentialsForm, {
      input: input,
      newPolicy: newPolicy,
      updatePolicy: updatePolicy,
      packageInfo: packageInfo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    }));
  }
});