"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupByActionVariables = void 0;
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _apm = require("../../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renameActionVariable = field => {
  switch (field) {
    case _apm.SERVICE_NAME:
      return 'serviceName';
    case _apm.SERVICE_ENVIRONMENT:
      return 'environment';
    case _apm.TRANSACTION_TYPE:
      return 'transactionType';
    case _apm.TRANSACTION_NAME:
      return 'transactionName';
    case _apm.ERROR_GROUP_ID:
      return 'errorGroupingKey';
    case _apm.ERROR_GROUP_NAME:
      return 'errorGroupingName';
    default:
      return field;
  }
};
const getGroupByActionVariables = groupByFields => {
  return Object.keys(groupByFields).reduce((acc, cur) => {
    acc[renameActionVariable(cur)] = (0, _apm_rule_types.getFieldValueLabel)(cur, groupByFields[cur]);
    return acc;
  }, {});
};
exports.getGroupByActionVariables = getGroupByActionVariables;