"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutCloseButtonStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _flyout = require("./flyout.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1ffeobd-inside",
  styles: "background-color:transparent;label:inside;"
} : {
  name: "1ffeobd-inside",
  styles: "background-color:transparent;label:inside;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFlyoutCloseButtonStyles = exports.euiFlyoutCloseButtonStyles = function euiFlyoutCloseButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyout__closeButton: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('right', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('top', euiTheme.size.s), " z-index:3;;label:euiFlyout__closeButton;"),
    inside: _ref,
    outside: /*#__PURE__*/(0, _react.css)((0, _euiThemeCommon.euiShadowXLarge)(euiThemeContext, {
      borderAllInHighContrastMode: true
    }), "animation:none!important;;label:outside;"),
    outsideSide: {
      // `transforms` pull in close buttons a little
      // `!important` is necessary here to override the hover/focus transitions of buttons
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.xs, "))!important;}", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.l, "))!important;};label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.xs, "))!important;}", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.l, "))!important;};label:left;")
    }
  };
};