"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoteManagementPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _delete_note_button = require("../components/delete_note_button");
var _title = require("../../common/components/header_page/title");
var _formatted_date = require("../../common/components/formatted_date");
var _ = require("..");
var _search_row = require("../components/search_row");
var _utility_bar = require("../components/utility_bar");
var _delete_confirm_modal = require("../components/delete_confirm_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _open_flyout_button = require("../components/open_flyout_button");
var _open_timeline_button = require("../components/open_timeline_button");
var _note_content = require("../components/note_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/pages/note_management_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO unify this type from the api with the one in public/common/lib/note
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = [{
  name: i18n.ACTIONS_COLUMN,
  render: note => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            min-width: 24px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, note.eventId ? /*#__PURE__*/_react.default.createElement(_open_flyout_button.OpenFlyoutButtonIcon, {
    eventId: note.eventId,
    timelineId: note.timelineId,
    iconType: "expand",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            min-width: 24px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, note.timelineId ? /*#__PURE__*/_react.default.createElement(_open_timeline_button.OpenTimelineButtonIcon, {
    note: note,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 32
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            min-width: 24px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_note_button.DeleteNoteButtonIcon, {
    note: note,
    index: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))),
  width: '72px'
}, {
  field: 'createdBy',
  name: i18n.CREATED_BY_COLUMN,
  render: createdBy => /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: createdBy || '',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 47
    }
  }),
  width: '100px',
  align: 'center'
}, {
  field: 'note',
  name: i18n.NOTE_CONTENT_COLUMN,
  render: note => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, note && /*#__PURE__*/_react.default.createElement(_note_content.NoteContent, {
    note: note,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 48
    }
  }))
}, {
  field: 'created',
  name: i18n.CREATED_COLUMN,
  sortable: true,
  render: created => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: created,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 43
    }
  }),
  width: '225px'
}];
const pageSizeOptions = [10, 25, 50, 100];

/**
 * Allows user to search and delete notes.
 * This component uses the same slices of state as the notes functionality of the rest of the Security Solution applicaiton.
 * Therefore, changes made in this page (like fetching or deleting notes) will have an impact everywhere.
 */
const NoteManagementPage = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const notes = (0, _reactRedux.useSelector)(_.selectAllNotes);
  const notesReversed = (0, _reactRedux.useSelector)(_.selectAllReversed);
  const pagination = (0, _reactRedux.useSelector)(_.selectNotesPagination);
  const sort = (0, _reactRedux.useSelector)(_.selectNotesTableSort);
  const notesSearch = (0, _reactRedux.useSelector)(_.selectNotesTableSearch);
  const notesCreatedByFilter = (0, _reactRedux.useSelector)(_.selectNotesTableCreatedByFilter);
  const notesAssociatedFilter = (0, _reactRedux.useSelector)(_.selectNotesTableAssociatedFilter);
  const pendingDeleteIds = (0, _reactRedux.useSelector)(_.selectNotesTablePendingDeleteIds);
  const isDeleteModalVisible = pendingDeleteIds.length > 0;
  const fetchNotesStatus = (0, _reactRedux.useSelector)(_.selectFetchNotesStatus);
  const fetchLoading = fetchNotesStatus === _.ReqStatus.Loading;
  const fetchError = fetchNotesStatus === _.ReqStatus.Failed;
  const fetchErrorData = (0, _reactRedux.useSelector)(_.selectFetchNotesError);
  const tableNotes = (0, _react.useMemo)(() => {
    return sort.direction === 'asc' ? notes : notesReversed;
  }, [notes, notesReversed, sort.direction]);
  const fetchData = (0, _react.useCallback)(() => {
    dispatch((0, _.fetchNotes)({
      page: pagination.page,
      perPage: pagination.perPage,
      sortField: sort.field,
      sortOrder: sort.direction,
      filter: '',
      createdByFilter: notesCreatedByFilter,
      associatedFilter: notesAssociatedFilter,
      search: notesSearch
    }));
  }, [dispatch, pagination.page, pagination.perPage, sort.field, sort.direction, notesCreatedByFilter, notesAssociatedFilter, notesSearch]);
  (0, _react.useEffect)(() => {
    fetchData();
  }, [fetchData]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort: newSort
  }) => {
    if (page) {
      dispatch((0, _.userSelectedPage)(page.index + 1));
      dispatch((0, _.userSelectedPerPage)(page.size));
    }
    if (newSort) {
      dispatch((0, _.userSortedNotes)({
        field: newSort.field,
        direction: newSort.direction
      }));
    }
  }, [dispatch]);
  const onSelectionChange = (0, _react.useCallback)(selection => {
    const rowIds = selection.map(item => item.noteId);
    dispatch((0, _.userSelectedRow)(rowIds));
  }, [dispatch]);
  const itemIdSelector = (0, _react.useCallback)(item => {
    return item.noteId;
  }, []);
  const currentPagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.perPage,
      totalItemCount: pagination.total,
      pageSizeOptions
    };
  }, [pagination]);
  const selection = (0, _react.useMemo)(() => {
    return {
      onSelectionChange,
      selectable: () => true
    };
  }, [onSelectionChange]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort
    };
  }, [sort]);
  if (fetchError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 16
        }
      }, i18n.TABLE_ERROR),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 15
        }
      }, fetchErrorData),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: i18n.NOTES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.NotesUtilityBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: tableNotes,
    pagination: currentPagination,
    columns: columns,
    onChange: onTableChange,
    selection: selection,
    sorting: sorting,
    itemId: itemIdSelector,
    loading: fetchLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), isDeleteModalVisible && /*#__PURE__*/_react.default.createElement(_delete_confirm_modal.DeleteConfirmModal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 32
    }
  }));
};
exports.NoteManagementPage = NoteManagementPage;
NoteManagementPage.displayName = 'NoteManagementPage';