"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderWrappedHook = exports.renderQuery = exports.renderMutation = exports.getFakeListId = exports.getFakeListDefinition = exports.getFakeHttpService = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@testing-library/react");
var _mocks = require("@kbn/core/public/mocks");
var _query_client_provider = require("../../common/containers/query_client/query_client_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/hooks/test_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getFakeListId = () => 'FAKE_LIST_ID';
exports.getFakeListId = getFakeListId;
const getFakeListDefinition = () => ({
  name: 'FAKE_LIST_NAME',
  namespace_type: 'agnostic',
  description: 'FAKE_LIST_DESCRIPTION',
  list_id: getFakeListId(),
  type: 'endpoint'
});
exports.getFakeListDefinition = getFakeListDefinition;
const getFakeHttpService = () => {
  const fakeCoreStart = _mocks.coreMock.createStart({
    basePath: '/mock'
  });
  const fakeHttpServices = fakeCoreStart.http;
  fakeHttpServices.post.mockClear();
  fakeHttpServices.get.mockClear();
  fakeHttpServices.put.mockClear();
  fakeHttpServices.delete.mockClear();
  return fakeHttpServices;
};
exports.getFakeHttpService = getFakeHttpService;
const renderQuery = async (hook, waitForHook = 'isSuccess') => {
  const wrapper = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, children);
  const {
    result: resultHook
  } = (0, _react2.renderHook)(() => hook(), {
    wrapper
  });
  await (0, _react2.waitFor)(() => expect(resultHook.current[waitForHook]).toBeTruthy(), {
    timeout: 5000
  });
  return resultHook.current;
};
exports.renderQuery = renderQuery;
const renderMutation = async hook => {
  const wrapper = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, children);
  const {
    result: resultHook
  } = (0, _react2.renderHook)(() => hook(), {
    wrapper
  });
  return resultHook.current;
};
exports.renderMutation = renderMutation;
const renderWrappedHook = exports.renderWrappedHook = renderMutation;