"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponseActionItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_response/policy_response_action_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiCallout = (0, _styledComponents.default)(_eui.EuiCallOut)`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  white-space: break-spaces;
  text-align: left;
  line-height: inherit;
`;
/**
 * A policy response action item
 */
const PolicyResponseActionItem = exports.PolicyResponseActionItem = /*#__PURE__*/(0, _react.memo)(({
  policyResponseActionFormatter
}) => {
  return policyResponseActionFormatter.hasError ? /*#__PURE__*/_react.default.createElement(StyledEuiCallout, {
    title: policyResponseActionFormatter.errorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "endpointPolicyResponseErrorCallOut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "s",
    "data-test-subj": "endpointPolicyResponseMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, policyResponseActionFormatter.errorDescription, policyResponseActionFormatter.linkText && policyResponseActionFormatter.linkUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: policyResponseActionFormatter.linkUrl,
    "data-test-subj": "endpointPolicyResponseErrorCallOutLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, policyResponseActionFormatter.linkText))) : /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "xs",
    "data-test-subj": "endpointPolicyResponseMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, policyResponseActionFormatter.description || policyResponseActionFormatter.title);
});
PolicyResponseActionItem.displayName = 'PolicyResponseActionItem';