"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageOverlay = exports.PAGE_OVERLAY_DOCUMENT_BODY_OVER_PAGE_WRAPPER_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_IS_VISIBLE_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _reactRouterDom = require("react-router-dom");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _page = require("../../../common/components/page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/page_overlay/page_overlay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverlayRootContainer = _styledComponents.default.div`
  border: none;

  display: block;
  position: fixed;
  overflow: hidden;

  top: var(--euiFixedHeadersOffset, 0);
  bottom: 0;
  right: 0;
  left: var(--euiCollapsibleNavOffset, 0);

  width: calc(100% - var(--euiCollapsibleNavOffset, 0));
  height: calc(100% - var(--euiFixedHeadersOffset, 0));

  border-left: 1px solid ${({
  theme: {
    eui
  }
}) => eui.euiColorLightestShade};

  z-index: ${({
  theme: {
    eui
  }
}) => eui.euiZFlyout + 3}; // we need to have this response div rendered above the timeline flyout (with z-index at 1002)

  background-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorEmptyShade};

  &.scrolling {
    overflow: auto;
  }

  &.hidden {
    display: none;
  }

  &.padding-xs {
    padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
  }
  &.padding-s {
    padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
  }
  &.padding-m {
    padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeM};
  }
  &.padding-l {
    padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeL};
  }
  &.padding-xl {
    padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXL};
  }

  &.fullScreen {
    top: 0;
    height: 100%;
  }

  .fullHeight {
    height: 100%;
  }
`;
const PAGE_OVERLAY_CSS_CLASSNAME = 'securitySolution-pageOverlay';
const PAGE_OVERLAY_DOCUMENT_BODY_IS_VISIBLE_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_IS_VISIBLE_CLASSNAME = `${PAGE_OVERLAY_CSS_CLASSNAME}-isVisible`;
const PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME = `${PAGE_OVERLAY_CSS_CLASSNAME}-lock`;
const PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME = `${PAGE_OVERLAY_CSS_CLASSNAME}-fullScreen`;
const PAGE_OVERLAY_DOCUMENT_BODY_OVER_PAGE_WRAPPER_CLASSNAME = exports.PAGE_OVERLAY_DOCUMENT_BODY_OVER_PAGE_WRAPPER_CLASSNAME = `${PAGE_OVERLAY_CSS_CLASSNAME}-overSecuritySolutionPageWrapper`;
const PageOverlayGlobalStyles = (0, _styledComponents.createGlobalStyle)`
  body.${PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME} {
    overflow: hidden;
  }

  //-------------------------------------------------------------------------------------------
  // Style overrides for when Page Overlay is in full screen mode
  //-------------------------------------------------------------------------------------------
  // Needs to override some position of EUI components to ensure they are displayed correctly
  // when the top Kibana header is not visible
  //-------------------------------------------------------------------------------------------
  body.${PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME} {
    ${_page.FULL_SCREEN_CONTENT_OVERRIDES_CSS_STYLESHEET}
  }
`;
const setDocumentBodyOverlayIsVisible = () => {
  document.body.classList.add(PAGE_OVERLAY_DOCUMENT_BODY_IS_VISIBLE_CLASSNAME);
};
const unSetDocumentBodyOverlayIsVisible = () => {
  document.body.classList.remove(PAGE_OVERLAY_DOCUMENT_BODY_IS_VISIBLE_CLASSNAME);
};
const setDocumentBodyLock = () => {
  document.body.classList.add(PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME);
};
const unSetDocumentBodyLock = () => {
  document.body.classList.remove(PAGE_OVERLAY_DOCUMENT_BODY_LOCK_CLASSNAME);
};
const setDocumentBodyFullScreen = () => {
  document.body.classList.add(PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME);
};
const unSetDocumentBodyFullScreen = () => {
  document.body.classList.remove(PAGE_OVERLAY_DOCUMENT_BODY_FULLSCREEN_CLASSNAME);
};
const setDocumentBodyOverPageWrapper = () => {
  document.body.classList.add(PAGE_OVERLAY_DOCUMENT_BODY_OVER_PAGE_WRAPPER_CLASSNAME);
};
const unSetDocumentBodyOverPageWrapper = () => {
  document.body.classList.remove(PAGE_OVERLAY_DOCUMENT_BODY_OVER_PAGE_WRAPPER_CLASSNAME);
};
/**
 * A generic component for taking over the entire Kibana UI main content area (everything below the
 * top header that includes the breadcrumbs). This component adds nothing more than a blank page - its up
 * to the `children` pass to actually display any type of intractable UI for the user.
 */
const PageOverlay = exports.PageOverlay = /*#__PURE__*/(0, _react.memo)(({
  children,
  onHide,
  isHidden = false,
  enableScrolling = true,
  hideOnUrlPathnameChange = true,
  lockDocumentBody = true,
  appendAsBodyLastNode = true,
  paddingSize,
  zIndex,
  'data-test-subj': dataTestSubj
}) => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const showInFullScreen = (0, _use_full_screen.useHasFullScreenContent)();
  const [openedOnPathName, setOpenedOnPathName] = (0, _react.useState)(null);
  const portalEleRef = (0, _react.useRef)();
  const setPortalEleRef = (0, _react.useCallback)(node => {
    portalEleRef.current = node;
  }, []);
  const containerCssOverrides = (0, _react.useMemo)(() => {
    const css = {};
    if (zIndex) {
      css.zIndex = zIndex;
    }
    return css;
  }, [zIndex]);
  const containerClassName = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      [PAGE_OVERLAY_CSS_CLASSNAME]: true,
      scrolling: enableScrolling,
      hidden: isHidden,
      fullScreen: showInFullScreen,
      'eui-scrollBar': enableScrolling,
      'padding-xs': paddingSize === 'xs',
      'padding-s': paddingSize === 's',
      'padding-m': paddingSize === 'm',
      'padding-l': paddingSize === 'l',
      'padding-xl': paddingSize === 'xl'
    });
  }, [enableScrolling, isHidden, paddingSize, showInFullScreen]);

  // Capture the URL `pathname` that the overlay was opened for
  (0, _react.useEffect)(() => {
    if (isMounted()) {
      setOpenedOnPathName(prevState => {
        if (isHidden) {
          return null;
        } else {
          // capture pathname if not yet set (first show)
          if (!prevState) {
            // append the portal to the end of `<body>`?
            if (appendAsBodyLastNode && portalEleRef.current) {
              document.body.appendChild(portalEleRef.current);
            }
            return pathname;
          }
        }
        return prevState;
      });
    }
  }, [appendAsBodyLastNode, isHidden, isMounted, pathname]);

  // If `hideOnUrlPathNameChange` is true, then determine if the pathname changed and if so, call `onHide()`
  (0, _react.useEffect)(() => {
    if (isMounted() && hideOnUrlPathnameChange && !isHidden && openedOnPathName && openedOnPathName !== pathname) {
      onHide();
    }
  }, [hideOnUrlPathnameChange, isHidden, isMounted, onHide, openedOnPathName, pathname]);

  // Handle adding class names to the `document.body` DOM element
  (0, _react.useEffect)(() => {
    if (isMounted()) {
      const isOverSecuritySolutionPageWrapper = Boolean(document.querySelector('.securitySolutionWrapper'));
      if (isHidden) {
        unSetDocumentBodyOverlayIsVisible();
        unSetDocumentBodyLock();
        unSetDocumentBodyFullScreen();
        unSetDocumentBodyOverPageWrapper();
      } else {
        setDocumentBodyOverlayIsVisible();
        if (lockDocumentBody) {
          setDocumentBodyLock();
        }
        if (showInFullScreen) {
          setDocumentBodyFullScreen();
        }
        if (isOverSecuritySolutionPageWrapper) {
          setDocumentBodyOverPageWrapper();
        }
      }
    }
    return () => {
      unSetDocumentBodyLock();
      unSetDocumentBodyOverlayIsVisible();
      unSetDocumentBodyFullScreen();
      unSetDocumentBodyOverPageWrapper();
    };
  }, [isHidden, isMounted, lockDocumentBody, showInFullScreen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    portalRef: setPortalEleRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(OverlayRootContainer, {
    "data-test-subj": dataTestSubj,
    className: containerClassName,
    style: containerCssOverrides,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    "data-test-subj": "trap-focus",
    className: "fullHeight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, children)), /*#__PURE__*/_react.default.createElement(PageOverlayGlobalStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }));
});
PageOverlay.displayName = 'PageOverlay';