"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointUploadActionResult = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _endpoint_action_failure_message = require("../endpoint_action_failure_message");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _key_value_display = require("../key_value_display");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_upload_action_result/endpoint_upload_action_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LABELS = Object.freeze({
  path: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.savedTo', {
    defaultMessage: 'File saved to'
  }),
  disk_free_space: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.freeDiskSpace', {
    defaultMessage: 'Free disk space on drive'
  }),
  noAgentResponse: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.missingAgentResult', {
    defaultMessage: 'Error: Agent result missing'
  }),
  host: _i18n.i18n.translate('xpack.securitySolution.endpointUploadActionResult.host', {
    defaultMessage: 'Host'
  })
});
const EndpointUploadActionResult = exports.EndpointUploadActionResult = /*#__PURE__*/(0, _react.memo)(({
  action: _action,
  agentId,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  const action = _action;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const outputs = (0, _react.useMemo)(() => {
    const hosts = [];
    const agents = agentId ? [agentId] : action.agents;
    for (const agent of agents) {
      var _action$outputs;
      hosts.push({
        name: action.hosts[agent].name,
        state: action.agentState[agent],
        result: (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : _action$outputs[agent]
      });
    }
    return hosts;
  }, [action.agentState, action.agents, action.hosts, action.outputs, agentId]);
  const showHostName = outputs.length > 1;
  if (action.command !== 'upload') {
    window.console.warn(`EndpointUploadActionResult: called with a non-upload action`);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (outputs.length === 0) {
    window.console.warn(`EndpointUploadActionResult: Agent id [${agentId}] not in list of agents for action`);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": getTestId(),
    size: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, outputs.map(({
    name,
    state,
    result
  }) => {
    // Use case: action log
    if (!state.isCompleted) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('pending'),
        key: name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpointUploadActionResult.pendingMessage",
        defaultMessage: "Action pending.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 17
        }
      }));
    }

    // if we don't have an agent result (for whatever reason)
    if (!result) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('noResultError'),
        key: name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 15
        }
      }, LABELS.noAgentResponse);
    }

    // Error result
    if (!state.wasSuccessful) {
      return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
        name: showHostName ? name : undefined,
        "data-test-subj": getTestId('actionFailure'),
        key: name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_endpoint_action_failure_message.EndpointActionFailureMessage, {
        action: action,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 17
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(HostUploadResult, {
      name: showHostName ? name : undefined,
      "data-test-subj": getTestId('success'),
      key: name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
      name: LABELS.path,
      value: result.content.path,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
      name: LABELS.disk_free_space,
      value: (0, _numeral.default)(result.content.disk_free_space).format('0.00b'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 15
      }
    }));
  }));
});
EndpointUploadActionResult.displayName = 'EndpointUploadActionResult';
const HostUploadResult = /*#__PURE__*/(0, _react.memo)(({
  name,
  children,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, name && /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
    name: LABELS.host,
    value: name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 18
    }
  }), children, name && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 18
    }
  }));
});
HostUploadResult.displayName = 'HostUploadResult';