"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderEndpointInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_host_platform = require("../../../../../../common/lib/endpoint/utils/get_host_platform");
var _agent_status = require("../../../../../../common/components/endpoint/agents/agent_status");
var _header_agent_info = require("../header_agent_info");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/components/header_info/endpoint/header_endpoint_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeaderEndpointInfo = exports.HeaderEndpointInfo = /*#__PURE__*/(0, _react.memo)(({
  endpointId
}) => {
  const {
    data: endpointDetails,
    isLoading
  } = (0, _hooks.useGetEndpointDetails)(endpointId, {
    refetchInterval: 10000
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
  if (!endpointDetails) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_header_agent_info.HeaderAgentInfo, {
    platform: (0, _get_host_platform.getHostPlatform)(endpointDetails.metadata),
    hostName: endpointDetails.metadata.host.name,
    lastCheckin: endpointDetails.last_checkin,
    agentType: "endpoint",
    "data-test-subj": "responseConsole",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
    agentId: endpointId,
    agentType: "endpoint",
    "data-test-subj": "responderHeaderEndpointAgentIsolationStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
});
HeaderEndpointInfo.displayName = 'HeaderEndpointInfo';