"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointStatusActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _translations = require("../../../../common/components/endpoint/agents/agent_status/translations");
var _use_get_endpoint_pending_actions_summary = require("../../../hooks/response_actions/use_get_endpoint_pending_actions_summary");
var _formatted_date = require("../../../../common/components/formatted_date");
var _hooks = require("../../../hooks");
var _formatted_error = require("../../formatted_error");
var _console_code_block = require("../../console/components/console_code_block");
var _host_constants = require("../../../pages/endpoint_hosts/view/host_constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/status_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointStatusActionResult = exports.EndpointStatusActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  status,
  setStatus,
  store,
  setStore,
  ResultComponent
}) => {
  var _command$commandDefin, _command$commandDefin2;
  const endpointId = (_command$commandDefin = command.commandDefinition) === null || _command$commandDefin === void 0 ? void 0 : (_command$commandDefin2 = _command$commandDefin.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
  const {
    endpointPendingActions,
    endpointDetails,
    detailsFetchError,
    apiCalled
  } = store;
  const isPending = status === 'pending';
  const queryKey = (0, _react.useMemo)(() => {
    return (0, _uuid.v4)();
  }, []);
  const {
    data: fetchedEndpointDetails,
    error: fetchedDetailsError,
    isFetching,
    isFetched
  } = (0, _hooks.useGetEndpointDetails)(endpointId, {
    enabled: isPending,
    queryKey: [queryKey]
  });
  const {
    data: fetchedPendingActionsSummary
  } = (0, _use_get_endpoint_pending_actions_summary.useGetEndpointPendingActionsSummary)([endpointId], {
    enabled: isPending,
    queryKey: [queryKey, endpointId]
  });
  const pendingIsolationActions = (0, _react.useMemo)(() => {
    if (endpointPendingActions !== null && endpointPendingActions !== void 0 && endpointPendingActions.data.length) {
      var _pendingActions$isola, _pendingActions$uniso;
      const pendingActions = endpointPendingActions.data[0].pending_actions;
      return {
        pendingIsolate: (_pendingActions$isola = pendingActions.isolate) !== null && _pendingActions$isola !== void 0 ? _pendingActions$isola : 0,
        pendingUnIsolate: (_pendingActions$uniso = pendingActions.unisolate) !== null && _pendingActions$uniso !== void 0 ? _pendingActions$uniso : 0
      };
    }
    return {
      pendingIsolate: 0,
      pendingUnIsolate: 0
    };
  }, [endpointPendingActions === null || endpointPendingActions === void 0 ? void 0 : endpointPendingActions.data]);
  (0, _react.useEffect)(() => {
    if (!apiCalled) {
      setStore(prevState => {
        return {
          ...prevState,
          apiCalled: true
        };
      });
    }
  }, [apiCalled, setStore]);

  // update command store if endpoint details fetch api call completed
  (0, _react.useEffect)(() => {
    if (isFetched && isPending) {
      setStatus(detailsFetchError ? 'error' : 'success');
      setStore(prevState => {
        return {
          ...prevState,
          endpointDetails: fetchedEndpointDetails,
          detailsFetchError: fetchedDetailsError !== null && fetchedDetailsError !== void 0 ? fetchedDetailsError : undefined
        };
      });
    }
  }, [detailsFetchError, isFetched, setStatus, isPending, setStore, fetchedEndpointDetails, fetchedDetailsError]);

  // Update the store once we get back pending actions for this endpoint
  (0, _react.useEffect)(() => {
    if (fetchedPendingActionsSummary && !endpointPendingActions) {
      setStore(prevState => {
        return {
          ...prevState,
          endpointPendingActions: fetchedPendingActionsSummary
        };
      });
    }
  }, [fetchedPendingActionsSummary, setStore, endpointPendingActions]);
  const getStatusDescriptionList = (0, _react.useCallback)(() => {
    if (!endpointDetails) {
      return undefined;
    }
    const agentStatus = () => {
      var _endpointDetails$meta;
      let isolateStatus = '';
      if (pendingIsolationActions.pendingIsolate > 0) {
        isolateStatus = _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.isolating', {
          defaultMessage: 'Isolating'
        });
      } else if (pendingIsolationActions.pendingUnIsolate > 0) {
        isolateStatus = _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.releasing', {
          defaultMessage: 'Releasing'
        });
      } else if (endpointDetails !== null && endpointDetails !== void 0 && (_endpointDetails$meta = endpointDetails.metadata.Endpoint.state) !== null && _endpointDetails$meta !== void 0 && _endpointDetails$meta.isolation) {
        isolateStatus = _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.isolated', {
          defaultMessage: 'Isolated'
        });
      }
      return `${(0, _translations.getAgentStatusText)(endpointDetails.host_status)}${isolateStatus.length > 0 ? ` - ${isolateStatus}` : ''}`;
    };
    const statusData = [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.agentStatus', {
        defaultMessage: 'Agent status'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 22
        }
      }, agentStatus())
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.platform', {
        defaultMessage: 'Platform'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 22
        }
      }, endpointDetails.metadata.host.os.full)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.version', {
        defaultMessage: 'Version'
      })),
      description: endpointDetails.metadata.agent.version
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.policyStatus', {
        defaultMessage: 'Policy status'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 11
        }
      }, _host_constants.POLICY_STATUS_TO_TEXT[endpointDetails.metadata.Endpoint.policy.applied.status])
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.appliedPolicyVersion', {
        defaultMessage: 'Policy version'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 11
        }
      }, `v${endpointDetails.metadata.Endpoint.policy.applied.endpoint_policy_version}`)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.policyName', {
        defaultMessage: 'Policy name'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 11
        }
      }, endpointDetails.metadata.Endpoint.policy.applied.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.lastActive', {
        defaultMessage: 'Last active'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        fieldName: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.status.lastActive', {
          defaultMessage: 'Last active'
        }),
        value: endpointDetails.last_checkin,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 13
        }
      }))
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      columnWidths: [1, 4],
      listItems: statusData,
      "data-test-subj": 'agent-status-console-output',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 7
      }
    });
  }, [pendingIsolationActions.pendingIsolate, pendingIsolationActions.pendingUnIsolate, endpointDetails]);
  if (detailsFetchError) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      showAs: "failure",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: detailsFetchError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    }));
  }
  if (isFetching || !endpointDetails) {
    return /*#__PURE__*/_react.default.createElement(ResultComponent, {
      showAs: "pending",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    showTitle: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 10
    }
  }, getStatusDescriptionList());
});
EndpointStatusActionResult.displayName = 'EndpointStatusActionResult';