"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConsoleStore = exports.ConsoleStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_stored_input_history = require("./hooks/use_stored_input_history");
var _console_manager = require("../console_manager/console_manager");
var _state_reducer = require("./state_reducer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_state/console_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConsoleStateContext = /*#__PURE__*/(0, _react.createContext)(null);
/**
 * A Console wide data store for internal state management between inner components
 */
const ConsoleStateProvider = exports.ConsoleStateProvider = /*#__PURE__*/(0, _react.memo)(({
  commands,
  scrollToBottom,
  keyCapture,
  HelpComponent,
  dataTestSubj,
  storagePrefix,
  managedKey,
  children
}) => {
  const [getConsoleState, storeConsoleState] = (0, _console_manager.useWithManagedConsoleState)(managedKey);
  const storedInputHistoryData = (0, _use_stored_input_history.useStoredInputHistory)(storagePrefix);
  const saveInputHistoryData = (0, _use_stored_input_history.useSaveInputHistoryToStorage)(storagePrefix);
  const stateInitializer = (0, _react.useCallback)(stateInit => {
    const createdInitState = (0, _state_reducer.initiateState)(stateInit, getConsoleState ? getConsoleState() : undefined);
    createdInitState.input.history = storedInputHistoryData;
    return createdInitState;
  }, [getConsoleState, storedInputHistoryData]);
  const [state, dispatch] = (0, _react.useReducer)(_state_reducer.stateDataReducer, {
    commands,
    scrollToBottom,
    keyCapture,
    HelpComponent,
    dataTestSubj,
    storagePrefix
  }, stateInitializer);

  // Anytime `state` changes AND the console is under ConsoleManager's control, then
  // store the console's state to ConsoleManager. This is what enables a console to be
  // closed/re-opened while maintaining the console's content
  (0, _react.useEffect)(() => {
    if (storeConsoleState) {
      storeConsoleState(state);
    }
  }, [state, storeConsoleState]);

  // Anytime `input.history` changes and a `storagePrefix` is defined, then persist
  // the input history to storage
  (0, _react.useEffect)(() => {
    if (storagePrefix && state.input.history) {
      saveInputHistoryData(state.input.history);
    }
  }, [saveInputHistoryData, state.input.history, storagePrefix]);
  return /*#__PURE__*/_react.default.createElement(ConsoleStateContext.Provider, {
    value: {
      state,
      dispatch
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, children);
});
ConsoleStateProvider.displayName = 'ConsoleStateProvider';
const useConsoleStore = () => {
  const store = (0, _react.useContext)(ConsoleStateContext);
  if (!store) {
    throw new Error(`ConsoleStateContext not defined`);
  }
  return store;
};
exports.useConsoleStore = useConsoleStore;