"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonTab = exports.JSON_TAB_COPY_TO_CLIPBOARD_BUTTON_TEST_ID = exports.JSON_TAB_CONTENT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/json_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JSON_TAB_CONTENT_TEST_ID = exports.JSON_TAB_CONTENT_TEST_ID = 'jsonView';
const JSON_TAB_COPY_TO_CLIPBOARD_BUTTON_TEST_ID = exports.JSON_TAB_COPY_TO_CLIPBOARD_BUTTON_TEST_ID = `JsonTabCopyToClipboard`;

// import { useDocumentDetailsContext } from './context';

const FLYOUT_BODY_PADDING = 24;
const COPY_TO_CLIPBOARD_BUTTON_HEIGHT = 24;
const FLYOUT_FOOTER_HEIGHT = 72;
/**
 * Json view displayed in the document details expandable flyout right section and in the indicator flyout.
 */
const JsonTab = exports.JsonTab = /*#__PURE__*/(0, _react.memo)(({
  value,
  showFooterOffset,
  'data-test-subj': dataTestSubj
}) => {
  const jsonValue = JSON.stringify(value, null, 2);
  const flexGroupElement = (0, _react.useRef)(null);
  const [editorHeight, setEditorHeight] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    var _flexGroupElement$cur;
    const topPosition = (flexGroupElement === null || flexGroupElement === void 0 ? void 0 : (_flexGroupElement$cur = flexGroupElement.current) === null || _flexGroupElement$cur === void 0 ? void 0 : _flexGroupElement$cur.getBoundingClientRect().top) || 0;
    const footerOffset = showFooterOffset ? 0 : FLYOUT_FOOTER_HEIGHT;
    const height = window.innerHeight - topPosition - COPY_TO_CLIPBOARD_BUTTON_HEIGHT - FLYOUT_BODY_PADDING - footerOffset;
    if (height === 0) {
      return;
    }
    setEditorHeight(height);
  }, [setEditorHeight, showFooterOffset]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    ref: flexGroupElement,
    direction: "column",
    gutterSize: "none",
    "data-test-subj": `${dataTestSubj}${JSON_TAB_CONTENT_TEST_ID}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'flexEnd',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: jsonValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 15
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: 'copyClipboard',
    size: 'xs',
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.shared.jsonTab.copyToClipboardButtonAriaLabel', {
      defaultMessage: 'Copy to clipboard'
    }),
    "data-test-subj": `${dataTestSubj}${JSON_TAB_COPY_TO_CLIPBOARD_BUTTON_TEST_ID}`,
    onClick: copy,
    onKeyDown: copy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.shared.jsonTab.copyToClipboardButtonLabel",
    defaultMessage: "Copy to clipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.JsonCodeEditor, {
    json: value,
    height: editorHeight,
    hasLineNumbers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })));
});
JsonTab.displayName = 'JsonTab';