"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertPreviewButton = void 0;
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../document_details/preview/constants");
var _panel_keys = require("../../document_details/shared/constants/panel_keys");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/alert_preview_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Icon button showed on tables to launch a preview of the alert details panel.
 */
const AlertPreviewButton = ({
  id,
  indexName,
  'data-test-subj': dataTestSubj,
  scopeId
}) => {
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openAlertPreview = (0, _react.useCallback)(() => openPreviewPanel({
    id: _panel_keys.DocumentDetailsPreviewPanelKey,
    params: {
      id,
      indexName,
      scopeId,
      isPreviewMode: true,
      banner: _constants.ALERT_PREVIEW_BANNER
    }
  }), [openPreviewPanel, id, indexName, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "expand",
    "data-test-subj": dataTestSubj,
    onClick: openAlertPreview,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.alertPreview.ariaLabel', {
      defaultMessage: 'Preview alert with id {id}',
      values: {
        id
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};
exports.AlertPreviewButton = AlertPreviewButton;