"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
var _use_rule_details_link = require("../../document_details/shared/hooks/use_rule_details_link");
var _flyout_footer = require("../../shared/components/flyout_footer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/rule_details/preview/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Footer in rule preview panel
 */
const PreviewFooter = exports.PreviewFooter = /*#__PURE__*/(0, _react.memo)(({
  ruleId
}) => {
  const href = (0, _use_rule_details_link.useRuleDetailsLink)({
    ruleId
  });
  return href ? /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, {
    "data-test-subj": _test_ids.RULE_PREVIEW_FOOTER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    external: false,
    "data-test-subj": _test_ids.RULE_PREVIEW_OPEN_RULE_FLYOUT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.preview.rule.viewDetailsLabel', {
    defaultMessage: 'Show full rule details'
  }))))) : null;
});
PreviewFooter.displayName = 'PreviewFooter';