"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LeftPanelHeader = exports.EntityDetailsLeftPanelTab = exports.CspInsightLeftPanelSubTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _flyout_header = require("../../../../shared/components/flyout_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/components/left_panel/left_panel_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let EntityDetailsLeftPanelTab = exports.EntityDetailsLeftPanelTab = /*#__PURE__*/function (EntityDetailsLeftPanelTab) {
  EntityDetailsLeftPanelTab["RISK_INPUTS"] = "risk_inputs";
  EntityDetailsLeftPanelTab["OKTA"] = "okta_document";
  EntityDetailsLeftPanelTab["ENTRA"] = "entra_document";
  EntityDetailsLeftPanelTab["CSP_INSIGHTS"] = "csp_insights";
  EntityDetailsLeftPanelTab["FIELDS_TABLE"] = "fields_table";
  return EntityDetailsLeftPanelTab;
}({});
let CspInsightLeftPanelSubTab = exports.CspInsightLeftPanelSubTab = /*#__PURE__*/function (CspInsightLeftPanelSubTab) {
  CspInsightLeftPanelSubTab["MISCONFIGURATIONS"] = "misconfigurationTabId";
  CspInsightLeftPanelSubTab["VULNERABILITIES"] = "vulnerabilitiesTabId";
  CspInsightLeftPanelSubTab["ALERTS"] = "alertsTabId";
  return CspInsightLeftPanelSubTab;
}({});
/**
 * Header at the top of the left section.
 * Displays the investigation and insights tabs (visualize is hidden for 8.9).
 */
const LeftPanelHeader = exports.LeftPanelHeader = /*#__PURE__*/(0, _react.memo)(({
  selectedTabId,
  setSelectedTabId,
  tabs
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    css: (0, _react2.css)`
          background-color: ${euiTheme.colors.backgroundBaseSubdued};
          padding-bottom: 0 !important;
          border-block-end: none !important;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, renderTabs));
});
LeftPanelHeader.displayName = 'LeftPanelHeader';