"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.basicHostFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_date = require("../../../../common/components/formatted_date");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/host_right/fields/basic_host_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const basicHostFields = exports.basicHostFields = [{
  label: i18n.HOST_ID,
  getValues: hostData => {
    var _hostData$details$hos;
    return (_hostData$details$hos = hostData.details.host) === null || _hostData$details$hos === void 0 ? void 0 : _hostData$details$hos.id;
  },
  field: 'host.id'
}, {
  label: i18n.FIRST_SEEN,
  render: hostData => hostData.firstSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: hostData.firstSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  label: i18n.LAST_SEEN,
  render: hostData => hostData.lastSeen.date ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: hostData.lastSeen.date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  label: i18n.IP_ADDRESSES,
  field: 'host.ip',
  getValues: hostData => {
    var _hostData$details$hos2;
    return (_hostData$details$hos2 = hostData.details.host) === null || _hostData$details$hos2 === void 0 ? void 0 : _hostData$details$hos2.ip;
  },
  renderField: ip => {
    return /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: ip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 14
      }
    });
  }
}, {
  label: i18n.MAC_ADDRESSES,
  getValues: hostData => {
    var _hostData$details$hos3;
    return (_hostData$details$hos3 = hostData.details.host) === null || _hostData$details$hos3 === void 0 ? void 0 : _hostData$details$hos3.mac;
  },
  field: 'host.mac'
}, {
  label: i18n.PLATFORM,
  getValues: hostData => {
    var _hostData$details$hos4, _hostData$details$hos5;
    return (_hostData$details$hos4 = hostData.details.host) === null || _hostData$details$hos4 === void 0 ? void 0 : (_hostData$details$hos5 = _hostData$details$hos4.os) === null || _hostData$details$hos5 === void 0 ? void 0 : _hostData$details$hos5.platform;
  },
  field: 'host.os.platform'
}, {
  label: i18n.OS,
  getValues: hostData => {
    var _hostData$details$hos6, _hostData$details$hos7;
    return (_hostData$details$hos6 = hostData.details.host) === null || _hostData$details$hos6 === void 0 ? void 0 : (_hostData$details$hos7 = _hostData$details$hos6.os) === null || _hostData$details$hos7 === void 0 ? void 0 : _hostData$details$hos7.name;
  },
  field: 'host.os.name'
}, {
  label: i18n.FAMILY,
  getValues: hostData => {
    var _hostData$details$hos8, _hostData$details$hos9;
    return (_hostData$details$hos8 = hostData.details.host) === null || _hostData$details$hos8 === void 0 ? void 0 : (_hostData$details$hos9 = _hostData$details$hos8.os) === null || _hostData$details$hos9 === void 0 ? void 0 : _hostData$details$hos9.family;
  },
  field: 'host.os.family'
}, {
  label: i18n.VERSION,
  getValues: hostData => {
    var _hostData$details$hos10, _hostData$details$hos11;
    return (_hostData$details$hos10 = hostData.details.host) === null || _hostData$details$hos10 === void 0 ? void 0 : (_hostData$details$hos11 = _hostData$details$hos10.os) === null || _hostData$details$hos11 === void 0 ? void 0 : _hostData$details$hos11.version;
  },
  field: 'host.os.version'
}, {
  label: i18n.ARCHITECTURE,
  getValues: hostData => {
    var _hostData$details$hos12;
    return (_hostData$details$hos12 = hostData.details.host) === null || _hostData$details$hos12 === void 0 ? void 0 : _hostData$details$hos12.architecture;
  },
  field: 'host.architecture'
}];