"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allTabs = exports.SessionViewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _content = require("./content");
var _header = require("./header");
var _context = require("./context");
var tabs = _interopRequireWildcard(require("./tabs"));
var _panel_keys = require("../shared/constants/panel_keys");
var _session_view = require("../left/components/session_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/session_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const allTabs = exports.allTabs = [tabs.processTab, tabs.metadataTab, tabs.alertsTab];
/**
 * Displays node details panel for session view
 */
const SessionViewPanel = exports.SessionViewPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    selectedProcess,
    index,
    sessionEntityId,
    sessionStartTime,
    scopeId,
    investigatedAlertId
  } = (0, _context.useSessionViewPanelContext)();
  const selectedTabId = (0, _react.useMemo)(() => {
    // we use the value passed from the url and use it if it exists in the list of tabs to display
    if (path) {
      const selectedTab = allTabs.map(tab => tab.id).find(tabId => tabId === path.tab);
      if (selectedTab) {
        return selectedTab;
      }
    }

    // we default back to the first tab of the list of tabs to display in case everything else has failed
    return allTabs[0].id;
  }, [path]);
  const setSelectedTabId = (0, _react.useCallback)(tabId => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsSessionViewPanelKey,
      path: {
        tab: tabId
      },
      params: {
        eventId,
        indexName,
        selectedProcess,
        index,
        sessionEntityId,
        sessionStartTime,
        scopeId,
        investigatedAlertId,
        banner: _session_view.SESSION_VIEWER_BANNER
      }
    });
  }, [eventId, index, indexName, investigatedAlertId, openPreviewPanel, scopeId, selectedProcess, sessionEntityId, sessionStartTime]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: allTabs,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: allTabs,
    selectedTabId: selectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }));
});
SessionViewPanel.displayName = 'SessionViewPanel';