"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSharedListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _use_create_shared_list = require("../../hooks/use_create_shared_list");
var _translations = require("../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/create_shared_exception_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateSharedListFlyout = exports.CreateSharedListFlyout = /*#__PURE__*/(0, _react.memo)(({
  handleRefresh,
  http,
  handleCloseFlyout,
  addSuccess,
  addError
}) => {
  const {
    navigateToApp
  } = (0, _public.useKibana)().services.application;
  const {
    start: createSharedExceptionList,
    ...createSharedExceptionListState
  } = (0, _use_create_shared_list.useCreateSharedExceptionListWithOptionalSignal)();
  const ctrl = (0, _react.useRef)(new AbortController());
  let DetailProperty = /*#__PURE__*/function (DetailProperty) {
    DetailProperty["name"] = "name";
    DetailProperty["description"] = "description";
    return DetailProperty;
  }({});
  const [newListDetails, setNewListDetails] = (0, _react.useState)({
    name: '',
    description: ''
  });
  const onChange = ({
    target
  }, detailProperty) => {
    const {
      value
    } = target;
    setNewListDetails({
      ...newListDetails,
      [detailProperty]: value
    });
  };
  (0, _react.useEffect)(() => {
    if (createSharedExceptionListState.result != null) {
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _constants.SecurityPageName.exceptions,
        path: `/details/${createSharedExceptionListState.result.list_id}`
      });
    }
  }, [createSharedExceptionListState, navigateToApp]);
  const handleCreateSharedExceptionList = (0, _react.useCallback)(() => {
    if (!createSharedExceptionListState.loading && newListDetails.name !== '') {
      var _newListDetails$descr;
      ctrl.current = new AbortController();
      createSharedExceptionList({
        http,
        signal: ctrl.current.signal,
        name: newListDetails.name,
        description: (_newListDetails$descr = newListDetails.description) !== null && _newListDetails$descr !== void 0 ? _newListDetails$descr : ''
      });
    }
  }, [createSharedExceptionListState.loading, newListDetails.name, newListDetails.description, createSharedExceptionList, http]);
  const handleCreateSuccess = (0, _react.useCallback)(() => {
    addSuccess({
      text: (0, _translations.getSuccessText)(newListDetails.name),
      title: _translations.SUCCESS_TITLE
    });
    handleRefresh();
    handleCloseFlyout();
  }, [addSuccess, handleCloseFlyout, handleRefresh, newListDetails]);
  const handleCreateError = (0, _react.useCallback)(error => {
    var _error$message, _error$body;
    if (!(error !== null && error !== void 0 && (_error$message = error.message) !== null && _error$message !== void 0 && _error$message.includes('AbortError')) && !(error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message.includes('AbortError'))) {
      addError(error, {
        title: _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListErrorTitle', {
          defaultMessage: 'creation error'
        })
      });
    }
  }, [addError]);
  (0, _react.useEffect)(() => {
    if (!createSharedExceptionListState.loading) {
      if (createSharedExceptionListState !== null && createSharedExceptionListState !== void 0 && createSharedExceptionListState.result) {
        handleCreateSuccess();
      } else if (createSharedExceptionListState !== null && createSharedExceptionListState !== void 0 && createSharedExceptionListState.error) {
        handleCreateError(createSharedExceptionListState === null || createSharedExceptionListState === void 0 ? void 0 : createSharedExceptionListState.error);
      }
    }
  }, [createSharedExceptionListState === null || createSharedExceptionListState === void 0 ? void 0 : createSharedExceptionListState.error, createSharedExceptionListState.loading, createSharedExceptionListState.result, handleCreateError, handleCreateSuccess]);
  const createSharedExceptionListFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createSharedExceptionListFlyout'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    size: "s",
    onClose: handleCloseFlyout,
    "data-test-subj": "createSharedExceptionListFlyout",
    "aria-labelledby": createSharedExceptionListFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: createSharedExceptionListFlyoutTitleId,
    "data-test-subj": "createSharedExceptionListTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, _translations.CREATE_SHARED_LIST_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, _translations.CREATE_SHARED_LIST_NAME_FIELD), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _translations.CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER,
    value: newListDetails.name,
    onChange: e => onChange(e, DetailProperty.name),
    "aria-label": "Shared exception list name",
    "data-test-subj": "createSharedExceptionListNameInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, _translations.CREATE_SHARED_LIST_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _translations.CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER,
    value: newListDetails.description,
    onChange: e => onChange(e, DetailProperty.description),
    "aria-label": "Shared exception list description",
    "data-test-subj": "createSharedExceptionListDescriptionInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: handleCloseFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, _translations.CLOSE_FLYOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exception-lists-form-create-shared",
    onClick: handleCreateSharedExceptionList,
    disabled: newListDetails.name === '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, _translations.CREATE_BUTTON)))));
});
CreateSharedListFlyout.displayName = 'CreateSharedListFlyout';