"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivilegedAccessDetectionIntegration = exports.useEntityAnalyticsIntegrations = void 0;
var _public = require("@kbn/fleet-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isGetInfoResponse = integration => integration !== undefined;
const useEntityAnalyticsIntegrations = () => {
  const {
    data: okta
  } = (0, _public.useGetPackageInfoByKeyQuery)('entityanalytics_okta', undefined,
  // When package version is undefined it gets the latest version
  undefined,
  // No options required
  {
    suspense: true // Make query suspend, it needs tu be wrapped by <Suspense />
  });
  const {
    data: ad
  } = (0, _public.useGetPackageInfoByKeyQuery)('entityanalytics_ad', undefined,
  // When package version is undefined it gets the latest version
  {
    prerelease: true // This is a technical preview package, delete this line when it is GA
  }, {
    suspense: true
  });
  return [okta, ad].filter(isGetInfoResponse).map(({
    item
  }) => item);
};
exports.useEntityAnalyticsIntegrations = useEntityAnalyticsIntegrations;
const usePrivilegedAccessDetectionIntegration = () => {
  const {
    data: pad
  } = (0, _public.useGetPackageInfoByKeyQuery)('pad', undefined,
  // When package version is undefined it gets the latest version
  {
    prerelease: true // This is a technical preview package, delete this line when it is GA
  }, {
    suspense: false
  });
  return isGetInfoResponse(pad) ? pad.item : undefined;
};
exports.usePrivilegedAccessDetectionIntegration = usePrivilegedAccessDetectionIntegration;