"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntitiesListColumns = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _search_strategy = require("../../../../../common/search_strategy");
var _constants = require("../../../../flyout/entity_details/shared/constants");
var _formatted_date = require("../../../../common/components/formatted_date");
var _common = require("../../severity/common");
var _empty_value = require("../../../../common/components/empty_value");
var _constants2 = require("../constants");
var _helpers = require("../helpers");
var _translations = require("../../asset_criticality/translations");
var _common2 = require("../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/hooks/use_entities_list_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useEntitiesListColumns = () => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.actionsColumn.title",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    render: record => {
      const entityType = (0, _helpers.getEntityType)(record);
      const value = record.entity.name;
      const onClick = () => {
        const id = _constants.EntityPanelKeyByType[entityType];
        if (id) {
          var _EntityPanelParamByTy;
          openRightPanel({
            id,
            params: {
              [(_EntityPanelParamByTy = _constants.EntityPanelParamByType[entityType]) !== null && _EntityPanelParamByTy !== void 0 ? _EntityPanelParamByTy : '']: value,
              contextID: _constants2.ENTITIES_LIST_TABLE_ID,
              scopeId: _constants2.ENTITIES_LIST_TABLE_ID
            }
          });
        }
      };
      if (!value || !_constants.EntityPanelKeyByType[entityType]) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "expand",
        onClick: onClick,
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.entitiesList.entityPreview.ariaLabel', {
          defaultMessage: 'Preview entity with name {name}',
          values: {
            name: value
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      });
    },
    width: '5%'
  }, {
    field: 'entity.name',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.nameColumn.title",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }),
    sortable: true,
    truncateText: {
      lines: 2
    },
    render: (_, record) => {
      const entityType = (0, _helpers.getEntityType)(record);
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: _helpers.EntityIconByType[entityType],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement("span", {
        css: {
          paddingLeft: euiTheme.size.s
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 13
        }
      }, record.entity.name));
    },
    width: '25%'
  }, {
    field: 'entity.source',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.sourceColumn.title",
      defaultMessage: "Source",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }),
    width: '25%',
    truncateText: {
      lines: 2
    },
    render: source => {
      if (source != null) {
        return (0, _helpers.sourceFieldToText)(source);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'asset.criticality',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.criticalityColumn.title",
      defaultMessage: "Criticality",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: criticality => {
      if (criticality != null) {
        return /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 145,
            columnNumber: 18
          }
        }, _translations.CRITICALITY_LEVEL_TITLE[criticality]);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.riskScoreColumn.title",
      defaultMessage: "Risk score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: entity => {
      const entityType = (0, _helpers.getEntityType)(entity);
      const riskScore = (0, _fp.get)(_search_strategy.EntityTypeToScoreField[entityType], entity);
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "risk-score-truncate",
          title: `${riskScore}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 165,
            columnNumber: 13
          }
        }, (0, _common2.formatRiskScore)(riskScore));
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.riskLevelColumn.title",
      defaultMessage: "Risk Level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }),
    width: '10%',
    render: entity => {
      const entityType = (0, _helpers.getEntityType)(entity);
      const riskLevel = (0, _fp.get)(_search_strategy.EntityTypeToLevelField[entityType], entity);
      if (riskLevel != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: riskLevel,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 18
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: '@timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.entitiesList.lastUpdateColumn.title",
      defaultMessage: "Last Update",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 9
      }
    }),
    sortable: true,
    render: lastUpdate => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastUpdate,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 16
        }
      });
    },
    width: '15%'
  }];
};
exports.useEntitiesListColumns = useEntitiesListColumns;