"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummaryChartsPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../common/components");
var _header_section = require("../../../../common/components/header_section");
var _severity_level_panel = require("../severity_level_panel");
var _alerts_by_rule_panel = require("../alerts_by_rule_panel");
var _alerts_progress_bar_panel = require("../alerts_progress_bar_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_summary_charts_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.l}) {
  }
`;
const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 355px;
`;
const AlertsSummaryChartsPanel = ({
  alignHeader,
  filters,
  addFilter,
  panelHeight,
  query,
  runtimeMappings,
  signalIndexName,
  title = i18n.CHARTS_TITLE,
  isExpanded,
  setIsExpanded,
  groupBySelection,
  setGroupBySelection
}) => {
  const toggleQuery = (0, _react.useCallback)(status => {
    setIsExpanded(status);
  }, [setIsExpanded]);
  return /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    $toggleStatus: isExpanded,
    "data-test-subj": "alerts-charts-panel",
    hasBorder: true,
    height: panelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    outerDirection: "row",
    title: title,
    titleSize: "s",
    hideSubtitle: true,
    showInspectButton: false,
    toggleStatus: isExpanded,
    toggleAriaLabel: i18n.CHARTS_TITLE,
    toggleQuery: toggleQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), isExpanded && /*#__PURE__*/_react.default.createElement(StyledFlexGroup, {
    "data-test-subj": "alerts-charts-container",
    className: "eui-yScroll",
    wrap: true,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_level_panel.SeverityLevelPanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: !isExpanded,
    addFilter: addFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_rule_panel.AlertsByRulePanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: !isExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_progress_bar_panel.AlertsProgressBarPanel, {
    filters: filters,
    query: query,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    skip: !isExpanded,
    groupBySelection: groupBySelection,
    setGroupBySelection: setGroupBySelection,
    addFilter: addFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }))));
};
exports.AlertsSummaryChartsPanel = AlertsSummaryChartsPanel;
AlertsSummaryChartsPanel.displayName = 'AlertsSummaryChartsPanel';