"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionTypeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _check_permissions = require("./endpoint/check_permissions");
var _endpoint_response_action = require("./endpoint/endpoint_response_action");
var _rule_response_actions = require("../../../common/api/detection_engine/model/rule_response_actions");
var _osquery_response_action = require("./osquery/osquery_response_action");
var _constants = require("./constants");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/response_action_type_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  background: ${({
  theme
}) => theme.eui.euiColorLightestShade};

  .euiAccordion__buttonContent {
    padding: ${({
  theme
}) => theme.eui.euiSizeM};
  }
`;
const ResponseActionTypeFormComponent = ({
  item,
  onDeleteAction
}) => {
  var _useCheckEndpointPerm;
  const [_isOpen, setIsOpen] = (0, _react.useState)(true);
  const [data] = (0, _shared_imports.useFormData)();
  const action = (0, _lodash.get)(data, item.path);
  const editDisabled = (_useCheckEndpointPerm = (0, _check_permissions.useCheckEndpointPermissions)(action)) !== null && _useCheckEndpointPerm !== void 0 ? _useCheckEndpointPerm : false;
  const getResponseActionTypeForm = (0, _react.useMemo)(() => {
    if ((action === null || action === void 0 ? void 0 : action.actionTypeId) === _rule_response_actions.ResponseActionTypesEnum['.osquery']) {
      return /*#__PURE__*/_react.default.createElement(_osquery_response_action.OsqueryResponseAction, {
        item: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 14
        }
      });
    }
    if ((action === null || action === void 0 ? void 0 : action.actionTypeId) === _rule_response_actions.ResponseActionTypesEnum['.endpoint']) {
      return /*#__PURE__*/_react.default.createElement(_endpoint_response_action.EndpointResponseAction, {
        item: item,
        editDisabled: editDisabled,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 14
        }
      });
    }
    // Place for other ResponseActionTypes
    return null;
  }, [action === null || action === void 0 ? void 0 : action.actionTypeId, editDisabled, item]);
  const handleDelete = (0, _react.useCallback)(() => {
    onDeleteAction(item.id);
  }, [item, onDeleteAction]);
  const renderButtonContent = (0, _react.useMemo)(() => {
    const {
      logo,
      name
    } = (0, _constants.getActionDetails)(action === null || action === void 0 ? void 0 : action.actionTypeId);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: logo,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, name)));
  }, [action === null || action === void 0 ? void 0 : action.actionTypeId]);
  const renderExtraContent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "remove-response-action",
      iconType: "minusInCircle",
      color: "danger",
      className: "actAccordionActionForm__extraAction",
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.actionTypeForm.accordion.deleteIconAriaLabel', {
        defaultMessage: 'Delete'
      }),
      disabled: editDisabled,
      onClick: handleDelete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    });
  }, [editDisabled, handleDelete]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    initialIsOpen: true,
    key: item.id,
    id: item.id.toString(),
    onToggle: setIsOpen,
    paddingSize: "l",
    "data-test-subj": `alertActionAccordion`,
    buttonContent: renderButtonContent,
    extraAction: renderExtraContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, getResponseActionTypeForm);
};
ResponseActionTypeFormComponent.displayName = 'ResponseActionTypeForm';
const ResponseActionTypeForm = exports.ResponseActionTypeForm = /*#__PURE__*/_react.default.memo(ResponseActionTypeFormComponent);