"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceReadOnly = DataSourceReadOnly;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _rule_definition_section = require("../../../../rule_definition_section");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var _utility_types = require("../../../../../../../../../common/utility_types");
var _empty_field_value_placeholder = require("../../empty_field_value_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/fields/data_source/data_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DataSourceReadOnly({
  dataSource
}) {
  if (!dataSource) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.DATA_SOURCE_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_empty_field_value_placeholder.EmptyFieldValuePlaceholder, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 28,
            columnNumber: 26
          }
        })
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 7
      }
    });
  }
  if (dataSource.type === _detection_engine.DataSourceType.index_patterns) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.INDEX_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Index, {
          index: dataSource.index_patterns,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 26
          }
        })
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    });
  }
  if (dataSource.type === _detection_engine.DataSourceType.data_view) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.DATA_VIEW_ID_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.DataViewId, {
          dataViewId: dataSource.data_view_id,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 26
          }
        })
      }, {
        title: ruleDetailsI18n.DATA_VIEW_INDEX_PATTERN_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.DataViewIndexPattern, {
          dataViewId: dataSource.data_view_id,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 26
          }
        })
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  }
  return (0, _utility_types.assertUnreachable)(dataSource);
}