"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleGapsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _use_get_rule_ids_with_gaps = require("../../api/hooks/use_get_rule_ids_with_gaps");
var _constants = require("../../constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _constants2 = require("../../../../../common/constants");
var _link_to = require("../../../../common/components/link_to");
var _rules_table_toolbar = require("../../../rule_management_ui/components/rules_table/rules_table_toolbar");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_gaps_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DISMISSAL_STORAGE_KEY = 'rule-gaps-callout-dismissed';
const RuleGapsCallout = () => {
  const {
    docLinks,
    spaces
  } = (0, _kibana.useKibana)().services;
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const [spaceId, setSpaceId] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (spaces) {
      spaces.getActiveSpace().then(space => setSpaceId(space.id));
    }
  }, [spaces]);
  const storeGapsInEventLogEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('storeGapsInEventLogEnabled');
  const [isDismissed, setIsDismissed] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_get_rule_ids_with_gaps.useGetRuleIdsWithGaps)({
    gapRange: _constants.GapRangeValue.LAST_24_H,
    statuses: [_common.gapStatus.UNFILLED, _common.gapStatus.PARTIALLY_FILLED],
    hasUnfilledIntervals: true
  });
  (0, _react.useEffect)(() => {
    const checkDismissalStatus = () => {
      const dismissalData = localStorage.getItem(DISMISSAL_STORAGE_KEY);
      if (!dismissalData || !(data !== null && data !== void 0 && data.latest_gap_timestamp)) return;
      const {
        timestamp,
        latestGapTimestamp
      } = JSON.parse(dismissalData);
      const dismissalTime = (0, _moment.default)(timestamp);
      const now = (0, _moment.default)();

      // Show callout again if 24 hours passed or there's a newer gap
      const hasNewerGap = latestGapTimestamp && (0, _moment.default)(data.latest_gap_timestamp).isAfter((0, _moment.default)(latestGapTimestamp));
      const isExpired = now.diff(dismissalTime, 'hours') >= 24;
      if (hasNewerGap || isExpired) {
        setIsDismissed(false);
        localStorage.removeItem(DISMISSAL_STORAGE_KEY);
      } else {
        setIsDismissed(true);
      }
    };
    checkDismissalStatus();
  }, [data === null || data === void 0 ? void 0 : data.latest_gap_timestamp]);
  const handleDismiss = (0, _react.useCallback)(() => {
    const dismissalData = {
      timestamp: (0, _moment.default)().toISOString(),
      latestGapTimestamp: data === null || data === void 0 ? void 0 : data.latest_gap_timestamp
    };
    localStorage.setItem(DISMISSAL_STORAGE_KEY, JSON.stringify(dismissalData));
    setIsDismissed(true);
  }, [data === null || data === void 0 ? void 0 : data.latest_gap_timestamp]);
  if (!data || (data === null || data === void 0 ? void 0 : data.total) === 0 || !storeGapsInEventLogEnabled || isDismissed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _translations.RULE_GAPS_CALLOUT_TITLE,
    iconType: "warning",
    onDismiss: handleDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.ruleGaps.callout.message",
    defaultMessage: "Gaps in rule executions might lead to missing alerts. Go to the Rule Monitoring tab to find affected rules and begin remediating gaps. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.siem.gapsTable,
        "data-test-subj": "monitoringLogsLink",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.securitySolution.ruleGaps.callout.messageLink', {
        defaultMessage: 'Learn more'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, spaceId && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: getSecuritySolutionUrl({
      deepLinkId: _constants2.SecurityPageName.rules,
      path: _rules_table_toolbar.AllRulesTabs.monitoring
    }),
    fill: true,
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, _translations.RULE_GAPS_CALLOUT_MONITORING_TAB), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: getSecuritySolutionUrl({
      deepLinkId: _constants2.SecurityPageName.dashboards,
      path: `security-detection-rule-monitoring-${spaceId}`
    }),
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, _translations.RULE_GAPS_CALLOUT_DASHBOARD)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }));
};
exports.RuleGapsCallout = RuleGapsCallout;