"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceQueryTextAliases = exports.ExecutionLogSearchBar = exports.EXECUTION_LOG_SCHEMA_MAPPING = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _execution_log = require("../../../../../../common/detection_engine/rule_management/execution_log");
var _rule_monitoring = require("../../../../rule_monitoring");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/execution_log_table/execution_log_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXECUTION_LOG_SCHEMA_MAPPING = exports.EXECUTION_LOG_SCHEMA_MAPPING = {
  status: 'kibana.alert.rule.execution.status',
  timestamp: '@timestamp',
  duration: 'event.duration',
  message: 'message',
  gapDuration: 'kibana.alert.rule.execution.metrics.execution_gap_duration_s',
  indexDuration: 'kibana.alert.rule.execution.metrics.total_indexing_duration_ms',
  searchDuration: 'kibana.alert.rule.execution.metrics.total_search_duration_ms',
  totalActions: 'kibana.alert.rule.execution.metrics.number_of_triggered_actions',
  schedulingDelay: 'kibana.task.schedule_delay'
};
const replaceQueryTextAliases = queryText => {
  return Object.entries(EXECUTION_LOG_SCHEMA_MAPPING).reduce((updatedQuery, [key, value]) => {
    return (0, _lodash.replace)(updatedQuery, key, value);
  }, queryText);
};
exports.replaceQueryTextAliases = replaceQueryTextAliases;
/**
 * SearchBar + StatusFilters component to be used with the Rule Execution Log table
 * NOTE: The SearchBar component is currently not shown in the UI as custom search queries
 * are not yet fully supported by the Rule Execution Log aggregation API since
 * certain queries could result in missing data or inclusion of wrong events.
 * Please see this comment for history/details: https://github.com/elastic/kibana/pull/127339/files#r825240516
 */
const ExecutionLogSearchBar = exports.ExecutionLogSearchBar = /*#__PURE__*/_react.default.memo(({
  onlyShowFilters,
  selectedStatuses,
  onStatusFilterChange,
  onSearch,
  selectedRunTypes,
  onRunTypeFilterChange
}) => {
  const handleSearch = (0, _react.useCallback)(queryText => {
    onSearch(replaceQueryTextAliases(queryText));
  }, [onSearch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, !onlyShowFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "executionLogSearch",
    "aria-label": i18n.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER,
    placeholder: i18n.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER,
    onSearch: handleSearch,
    isClearable: true,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionRunTypeFilter, {
    items: _execution_log.RUN_TYPE_FILTERS,
    selectedItems: selectedRunTypes,
    onChange: onRunTypeFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_monitoring.ExecutionStatusFilter, {
    items: _execution_log.STATUS_FILTERS,
    selectedItems: selectedStatuses,
    onChange: onStatusFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  })))));
});
ExecutionLogSearchBar.displayName = 'ExecutionLogSearchBar';