"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/eql_query_edit/errors_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ErrorsPopover = ({
  ariaLabel,
  errors
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleToggle = (0, _react.useCallback)(() => {
    setIsOpen(!isOpen);
  }, [isOpen]);
  const handleClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "eql-validation-errors-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "eql-validation-errors-popover-button",
      iconType: "error",
      size: "s",
      color: "danger",
      "aria-label": ariaLabel,
      onClick: handleToggle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, errors.length),
    isOpen: isOpen,
    closePopover: handleClose,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "eql-validation-errors-popover-content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, i18n.EQL_VALIDATION_ERRORS_TITLE), errors.map((message, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, message))));
};
exports.ErrorsPopover = ErrorsPopover;