"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTableLensAttributes = void 0;
var _uuid = require("uuid");
var _lodash = require("lodash");
var _translations = require("../../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const layerId = `layer-id-${(0, _uuid.v4)()}`;
const topValuesOfStackByFieldColumnId = `top-values-of-stack-by-field-column-id-${(0, _uuid.v4)()}`;
const countColumnId = `count-column-id-${(0, _uuid.v4)()}`;
const topValuesOfBreakdownFieldColumnId = `top-values-of-breakdown-field-column-id-${(0, _uuid.v4)()}`;
const defaultColumns = [{
  columnId: topValuesOfStackByFieldColumnId,
  isTransposed: false,
  width: 362
}, {
  columnId: countColumnId,
  isTransposed: false
}];
const breakdownFieldColumns = [{
  columnId: topValuesOfBreakdownFieldColumnId,
  isTransposed: false
}];
const defaultColumnOrder = [topValuesOfStackByFieldColumnId];
const getTopValuesOfBreakdownFieldColumnSettings = breakdownField => ({
  [topValuesOfBreakdownFieldColumnId]: {
    label: (0, _translations.TOP_VALUE)(breakdownField),
    dataType: 'string',
    operationType: 'terms',
    scale: 'ordinal',
    sourceField: breakdownField,
    isBucketed: true,
    params: {
      size: 1000,
      orderBy: {
        type: 'column',
        columnId: countColumnId
      },
      orderDirection: 'desc',
      otherBucket: true,
      missingBucket: false,
      parentFormat: {
        id: 'terms'
      },
      include: [],
      exclude: [],
      includeIsRegex: false,
      excludeIsRegex: false
    }
  }
});
const getAlertsTableLensAttributes = ({
  stackByField = 'kibana.alert.rule.name',
  extraOptions
}) => {
  const breakdownFieldProvided = !(0, _lodash.isEmpty)(extraOptions === null || extraOptions === void 0 ? void 0 : extraOptions.breakdownField);
  const countField = extraOptions !== null && extraOptions !== void 0 && extraOptions.breakdownField && breakdownFieldProvided ? extraOptions === null || extraOptions === void 0 ? void 0 : extraOptions.breakdownField : stackByField;
  const columnOrder = breakdownFieldProvided ? [...defaultColumnOrder, topValuesOfBreakdownFieldColumnId, countColumnId] : [...defaultColumnOrder, countColumnId];
  const columnSettings = {
    [topValuesOfStackByFieldColumnId]: {
      label: (0, _translations.TOP_VALUE)(stackByField),
      dataType: 'string',
      operationType: 'terms',
      scale: 'ordinal',
      sourceField: stackByField,
      isBucketed: true,
      params: {
        size: 1000,
        orderBy: {
          type: 'column',
          columnId: countColumnId
        },
        orderDirection: 'desc',
        otherBucket: true,
        missingBucket: false,
        parentFormat: {
          id: 'terms'
        },
        include: [],
        exclude: [],
        includeIsRegex: false,
        excludeIsRegex: false
      }
    },
    [countColumnId]: {
      label: (0, _translations.COUNT_OF)(countField),
      dataType: 'number',
      operationType: 'count',
      isBucketed: false,
      scale: 'ratio',
      sourceField: countField,
      params: {
        emptyAsNull: true
      }
    },
    ...(extraOptions !== null && extraOptions !== void 0 && extraOptions.breakdownField && breakdownFieldProvided ? getTopValuesOfBreakdownFieldColumnSettings(extraOptions === null || extraOptions === void 0 ? void 0 : extraOptions.breakdownField) : {})
  };
  return {
    title: 'Alerts',
    description: '',
    visualizationType: 'lnsDatatable',
    state: {
      visualization: {
        columns: breakdownFieldProvided ? [...defaultColumns, ...breakdownFieldColumns] : defaultColumns,
        layerId,
        layerType: 'data'
      },
      query: {
        query: '',
        language: 'kuery'
      },
      filters: extraOptions !== null && extraOptions !== void 0 && extraOptions.filters ? extraOptions.filters : [],
      datasourceStates: {
        formBased: {
          layers: {
            [layerId]: {
              columns: columnOrder.reduce((acc, colId) => {
                if (colId && columnSettings[colId]) {
                  acc[colId] = columnSettings[colId];
                }
                return acc;
              }, {}),
              columnOrder,
              sampling: 1,
              incompleteColumns: {}
            }
          }
        },
        textBased: {
          layers: {}
        }
      },
      internalReferences: [],
      adHocDataViews: {}
    },
    references: [{
      type: 'index-pattern',
      id: '{dataViewId}',
      name: `indexpattern-datasource-layer-${layerId}`
    }]
  };
};
exports.getAlertsTableLensAttributes = getAlertsTableLensAttributes;