"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/news_feed/news_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** prevents links to the new pages from accessing `window.opener` */
const REL_NOOPENER = 'noopener';

/** prevents search engine manipulation by noting the linked document is not trusted or endorsed by us */
const REL_NOFOLLOW = 'nofollow';

/** prevents the browser from sending the current address as referrer via the Referer HTTP header */
const REL_NOREFERRER = 'noreferrer';

/** A hyperlink to a (presumed to be external) news site */
const NewsLink = ({
  href,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: href,
  rel: `${REL_NOOPENER} ${REL_NOFOLLOW} ${REL_NOREFERRER}`,
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
}, children);
exports.NewsLink = NewsLink;